DELIMITER $$

DROP PROCEDURE IF EXISTS FEE_PAYER_EMAIL_ID $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE FEE_PAYER_EMAIL_ID()

BEGIN
  
   -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'FEE_PAYER_EMAIL_ID' and  objectName ='PERSON')) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PERSON','FEE_PAYER_EMAIL_ID','Email Id','Email Id',now(),1);

  END IF;
  
END $$

-- Execute the stored procedure
CALL FEE_PAYER_EMAIL_ID() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS FEE_PAYER_EMAIL_ID $$
 
DELIMITER ;