DELIMITER $$

DROP PROCEDURE IF EXISTS academylocationkohabranch $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE academylocationkohabranch()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academy_location_koha_branch' )) THEN

CREATE TABLE `academy_location_koha_branch` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `branchId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_academy_location_koha_branch_1_idx` (`academyLocationId`),
  KEY `fk_academy_location_koha_branch_2_idx` (`branchId`),
  KEY `fk_academy_location_koha_branch_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_academy_location_koha_branch_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_academy_location_koha_branch_2` FOREIGN KEY (`branchId`) REFERENCES `koha_branches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_academy_location_koha_branch_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	
  END IF;
  

END $$

-- Execute the stored procedure
CALL academylocationkohabranch $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS academylocationkohabranch $$
 
DELIMITER ;