DELIMITER $$

DROP PROCEDURE IF EXISTS V202001151405__UITranslation_HostelCaptureMsg $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001151405__UITranslation_HostelCaptureMsg()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'MegaMenuConstants' and keyName = 'CAPTURE_HOSTEL_ATTENDANCE' )) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('MegaMenuConstants','CAPTURE_HOSTEL_ATTENDANCE','Capture Hostel Attendance','Capture Hostel Attendance',now(),1);
   
  END IF;
  
   IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'MegaMenuConstants' and keyName = 'HOSTEL_ATTENDANCE_REPORT' )) THEN
    	    
    INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('MegaMenuConstants','HOSTEL_ATTENDANCE_REPORT','Hostel Attendance Report','Hostel Attendance Report',now(),1);
        
  END IF;

  
END $$


-- Execute the stored procedure
CALL V202001151405__UITranslation_HostelCaptureMsg() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001151405__UITranslation_HostelCaptureMsg $$
 
DELIMITER ;