DELIMITER $$

DROP PROCEDURE IF EXISTS ADD_PERSONS_GENDER_ID_COLUMN $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE ADD_PERSONS_GENDER_ID_COLUMN()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='genderId')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `persons` ADD COLUMN `genderId` BIGINT(20) NULL;

	set foreign_key_checks=0;
	ALTER TABLE `persons` 
	ADD CONSTRAINT `persons_fk_genderId`
	FOREIGN KEY (`genderId`)
	REFERENCES `gender` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  
  END IF;

END $$

-- Execute the stored procedure
CALL ADD_PERSONS_GENDER_ID_COLUMN $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS ADD_PERSONS_GENDER_ID_COLUMN $$
 
DELIMITER ;