DELIMITER $$

DROP PROCEDURE IF EXISTS V202001201633__Insert_CurrencyMasterListUITranslation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001201633__Insert_CurrencyMasterListUITranslation()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="CURRENCY_SETUP" )) THEN
	-- Insert Query 
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','CURRENCY_SETUP','Currency Setup','Currency Setup',now(),1);
  END IF;
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="CURRENCY_LIST" )) THEN
	-- Insert Query 
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','CURRENCY_LIST','Currency List','Currency List',now(),1);
  END IF;

END $$

-- Execute the stored procedure
CALL V202001201633__Insert_CurrencyMasterListUITranslation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001201633__Insert_CurrencyMasterListUITranslation $$
 
DELIMITER ;