set sql_safe_updates=0;
-- Update Outstanding Bill Reminder for Mother, Father, FeePayer, Student (Inactive).
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_MOTHER_REM_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FP_REM_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FATHER_REM_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_STUDENT_REM_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , \'%Y-%m-%d\')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , \'%Y-%m-%d\')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , \'%Y-%m-%d\'))
			) 
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_DL');

UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , \'%Y-%m-%d\')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , \'%Y-%m-%d\')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , \'%Y-%m-%d\'))
			) 
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_DL');

UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , \'%Y-%m-%d\')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , \'%Y-%m-%d\')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , \'%Y-%m-%d\'))
			) 
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_DL');
           
-- Story 2
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           (bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 3 day , \'%Y-%m-%d\')) OR 
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 2 day , \'%Y-%m-%d\')) OR
			bh.dueDate = (DATE_FORMAT(DATE(NOW()) + interval 1 day , \'%Y-%m-%d\'))
			) 
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FP_REM_ON_DAY_S2_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FP_REM_ON_DAY_S1_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_STU_REM_ON_DAY_DL');
           
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_STU_REM_ON_DAY_S2_DL');
set sql_safe_updates=1;