DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291225__Insert_MasterTimeTableCGC $$
CREATE PROCEDURE V202001291225__Insert_MasterTimeTableCGC()
BEGIN
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'MASTER_TIME_TABLE_PDF')) THEN 
INSERT INTO report_template (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('5', 'MASTER_TIME_TABLE_PDF', 'Master Timetable Excel', 'MASTER_TIME_TABLE_Excel.png', 'CommonReport_MasterTimeTableExcel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'MASTER_TIME_TABLE_Excel.jasper', 'AcademiaLogo.png');
END IF;


  IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId = (select id from report_template where templateCode ='MASTER_TIME_TABLE_PDF') )) THEN
  
  set @masterTimeTablePDF = (select id from report_template where templateCode ='MASTER_TIME_TABLE_PDF');
	
  INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES 	(@masterTimeTablePDF, 'TRANS_TIMETABLE', 'Timetable', '1',now()),
				(@masterTimeTablePDF, 'TRANS_PROGRAM', 'Program', '1', now()),
				(@masterTimeTablePDF, 'TRANS_BATCH','Batch','1',now()),
				(@masterTimeTablePDF, 'TRANS_PERIOD', 'Period', '1', now()),
	            (@masterTimeTablePDF, 'TRANS_SECTION_GROUP', 'Section Group', '1',now()),
	            (@masterTimeTablePDF, 'TRANS_SECTION', 'Section', '1',now()),
				(@masterTimeTablePDF, 'TRANS_DAY', 'Day/Session', '1', now()),
	            (@masterTimeTablePDF, 'TRANS_SESSION', 'Session', '1',now());
	
	END IF;
END $$
CALL V202001291225__Insert_MasterTimeTableCGC() $$
DROP PROCEDURE IF EXISTS V202001291225__Insert_MasterTimeTableCGC $$
DELIMITER ;