DELIMITER $$
DROP PROCEDURE IF EXISTS V20200224153532__Create_addObeCorrelationLevelTable $$
CREATE PROCEDURE V20200224153532__Create_addObeCorrelationLevelTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='obe_correlation_level')) THEN 
CREATE TABLE `obe_correlation_level` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `levelName` varchar(255) NOT NULL,
  `levelDescription` varchar(255) NOT NULL,
  `levelValue` bigint(20) NOT NULL,
  `lastUpdate` varchar(45) NOT NULL DEFAULT 'CURRENT_TIMESTAMP',
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `levelName_UNIQUE` (`levelName`),
  UNIQUE KEY `levelDescription_UNIQUE` (`levelDescription`),
  UNIQUE KEY `levelValue_UNIQUE` (`levelValue`),
  CONSTRAINT `fk_obe_correlation_level_users` FOREIGN KEY (`id`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200224153532__Create_addObeCorrelationLevelTable () $$ 
DROP PROCEDURE IF EXISTS V20200224153532__Create_addObeCorrelationLevelTable $$ 
DELIMITER ;