DELIMITER $$
DROP PROCEDURE IF EXISTS V20200225123642__Insert_RGI_Attendance_Report $$
CREATE PROCEDURE V20200225123642__Insert_RGI_Attendance_Report()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'RGI_ATTENDANCE_SHEET')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('19', 'RGI_ATTENDANCE_SHEET', '​Room Wise Attendance Report', 'RGI_ATTENDANCE_SHEET.png', 'RGI_CommonReport_PageNumber.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'RGI_ATTENDANCE_SHEET.jasper', 'AcademiaLogo.png');

set @rgiAttendanceReport = (select max(id) from report_template where templateCode ='RGI_ATTENDANCE_SHEET');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@rgiAttendanceReport, 'TRANS_ExaminationCenter', 'Examination Center: ', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_ROOM_NUMBER', 'Room Number: ', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_DATE_OF_EXAMINATION', 'Date of Examination: ', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_TIME_EXAMINATION', 'Time of Examination: ', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_INVIGILATOR_NAME', 'Name of Invigilator(s): ', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_SERIAL_NUMBER', 'SNo.', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_ENROLLMENT_NUMBER', 'Enrollment Number ', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_COURSE_NAME', 'Course', '1', NOW()),	
(@rgiAttendanceReport, 'TRANS_STUDENT_NAME', 'Student Name', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_ATTENDANCE', 'Attendance', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_SIGNATURE', 'Signature', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_TOTAL_STUDENT', 'Total:', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_STUDENTS', 'Students', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_EXAMINER_NAME', 'Examiner Name:', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_DATE', 'Date:', '1', NOW()),
(@rgiAttendanceReport, 'TRANS_SIGNATURE1', 'Signature:', '1', NOW());

END IF; 

END $$
CALL V20200225123642__Insert_RGI_Attendance_Report() $$
DROP PROCEDURE IF EXISTS V20200225123642__Insert_RGI_Attendance_Report $$
DELIMITER ;
