DELIMITER $$
DROP PROCEDURE IF EXISTS V20200225190105__Create_parentInfirmaryDetails $$
CREATE PROCEDURE V20200225190105__Create_parentInfirmaryDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='parent_infirmary_details' )) THEN 
CREATE TABLE `parent_infirmary_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `infirmaryId` BIGINT(25) NULL DEFAULT NULL,
  `personId` BIGINT(25) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(25) NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_new_table_1_idx` (`infirmaryId` ASC),
  INDEX `fk_new_table_personId_idx` (`personId` ASC),
  CONSTRAINT `fk_new_table_infirmaryId`
    FOREIGN KEY (`infirmaryId`)
    REFERENCES `infirmary_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_new_table_personId`
    FOREIGN KEY (`personId`)
    REFERENCES `persons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20200225190105__Create_parentInfirmaryDetails () $$ 
DROP PROCEDURE IF EXISTS V20200225190105__Create_parentInfirmaryDetails $$ 
DELIMITER ;
