DELIMITER $$
DROP PROCEDURE IF EXISTS V20200302123920__Create_TABLE_program_courses_period $$
CREATE PROCEDURE V20200302123920__Create_TABLE_program_courses_period()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='program_courses_period')) THEN 
CREATE TABLE `program_courses_period` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `programCourseId` BIGINT(20) NOT NULL,
  `periodId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `program_courses_period_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `program_courses_period_programCourseId`
    FOREIGN KEY (`programCourseId`)
    REFERENCES `program_courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `program_courses_period_periodId`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `program_courses_period_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20200302123920__Create_TABLE_program_courses_period () $$ 
DROP PROCEDURE IF EXISTS V20200302123920__Create_TABLE_program_courses_period $$ 
DELIMITER ;