DELIMITER $$
DROP PROCEDURE IF EXISTS V20200311144157__Insert_AddReportTemplate $$
CREATE PROCEDURE V20200311144157__Insert_AddReportTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'COURSE_ROSTER_REPORT_VARIANT_WISE' ))  THEN

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('21', 'COURSE_ROSTER_REPORT_VARIANT_WISE', 'Course Roster Report Course Variant Wise', 'COURSE_ROSTER_REPORT_VARIANT_WISE.png', 'CommonReport_PageNumber_Landscape.jasper', 'All', '1', 'FooterBlank_Landscape.jasper', 'FooterBlank_Landscape.jasper', '1', '1', 'COURSE_ROSTER_REPORT_VARIANT_WISE.jasper', 'AcademiaLogo.png');

set @courseRosterCourseVariantWiseReportID = (select max(id) from report_template where templateCode ='COURSE_ROSTER_REPORT_VARIANT_WISE');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@courseRosterCourseVariantWiseReportID, 'TRANS_CLASS_ATTENDANCE_SHEET', 'Class Attendance Sheet', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_TERM', 'Term:', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_DATE', 'Date:', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_COURSE_VARIANT', 'Course Variant:', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_COURSE', 'Course:', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_MENTOR', 'Mentor:', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_ALT_MENTOR', 'Alternative Mentor:', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_SR_NO', ' Sr.No.', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_STUDENT_ID', 'Student ID', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_STUDENT_FIRST_NAME', 'Student’s First Name', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_STUDENT_LAST_NAME', 'Student’s Last Name', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_ENROLLMENT_DATE', 'Enrollment Date', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_SIGNATURE', 'Signature', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_INSUTRUCTOR_SIGNATURE', 'Instructor Signature', '1', NOW()),
(@courseRosterCourseVariantWiseReportID, 'TRANS_GENDER', 'Gender', '1', NOW());

END IF; 

END $$
CALL V20200311144157__Insert_AddReportTemplate() $$
DROP PROCEDURE IF EXISTS V20200311144157__Insert_AddReportTemplate $$
DELIMITER ;
