DELIMITER $$
DROP PROCEDURE IF EXISTS V20200312181028__Create_table_section_master $$
CREATE PROCEDURE V20200312181028__Create_table_section_master()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='section_master')) THEN 
CREATE TABLE `section_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sectionCode` varchar(255) NOT NULL,
  `sectionName` varchar(255) NOT NULL,
  `sectionPrintName` varchar(255) NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `section_master_UNIQUE` (`sectionCode` ASC)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `moduleName`, `filterCode`,`whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) VALUES (@standardMasterMaxId + 1,'section_master', 'SECTION_MASTER', 'Program & Courses','COMMON_MASTER', 0, 0, '1', @currentTimeStamp);


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId+1, 'sectionCode', 'SECTION_CODE', @standardMasterMaxId + 1, 'Varchar', '1', 0, 0, 0, 0, '1', @currentTimeStamp);
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId+2, 'sectionName', 'SECTION_NAME', @standardMasterMaxId + 1, 'Varchar', '2', 0, 0, 0, 0, '1', @currentTimeStamp);
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES (@ItemsMaxId+3, 'sectionPrintName', 'SECTION_PRINT_NAME', @standardMasterMaxId + 1, 'Varchar', '3', 0, 0, 0, b'1', '1', @currentTimeStamp);
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) VALUES ('masterNames','SECTION_MASTER','Section Master','Section Master',now(),1);
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) VALUES ('TRANSLATIONS','SECTION_PRINT_NAME','Section Print Name','Section Print Name',now(),1);
END IF; 

END $$
CALL V20200312181028__Create_table_section_master () $$ 
DROP PROCEDURE IF EXISTS V20200312181028__Create_table_section_master $$ 
DELIMITER ;