DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402143024__Create_application_fee_view $$
CREATE PROCEDURE V20200402143024__Create_application_fee_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'application_fee_view')) THEN 
DROP view `application_fee_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'application_fee_view')) THEN 
CREATE OR REPLACE VIEW `application_fee_view` AS select 
        sum(`bfprs`.`billableAmount`) AS `INVOICES`,
        (select 
                sum(`receipt_header`.`amount`)
            from
                `receipt_header`
            where
                ((`receipt_header`.`applicantId` = `app`.`id`)
                    and (`receipt_header`.`academyLocationId` = `al`.`id`))) AS `RECEIPTS`,
        (sum(`bfprs`.`billableAmount`) - (select 
                sum(`receipt_header`.`amount`)
            from
                `receipt_header`
            where
                ((`receipt_header`.`applicantId` = `app`.`id`)
                    and (`receipt_header`.`academyLocationId` = `al`.`id`)))) AS `OUTSTANDING_AMOUNT`,
        sum(`bfprs`.`balanceAmount`) AS `OUTSTANDING_AMOUNT_BILL_SETTLED`,
        `app`.`id` AS `APPLICATION_ID`,
        `app`.`code` AS `APPLICATION_CODE`,
	`app`.`currentStatus` AS `APPLICATION_STATUS`,
        `app`.`applicationCreatedOn` AS `APPLICATION_DATE`,
        `ap`.`printName` AS `APPLICANT_NAME`,
	`ap`.`gender` AS `Gender`,
        `p`.`programName` AS `PROGRAM_NAME`,
        `b`.`batchName` AS `BATCH_NAME`,
        `iy`.`itemCode` AS `INTAKE_YEAR`,
        `iy`.`id` AS `intakeYearId`,
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `ac`.`academyName` AS `ACADEMY_NAME`,
        `lc`.`locationName` AS `LOCATION_NAME`,
        `p`.`id` AS `PROGRAM_ID`,
        `b`.`id` AS `BATCH_ID`,
        `al`.`displayName` AS `ACADEMY_LOCATION_NAME`
    from
        ((((((((((`bill_header` `bh`
        left join `bill_fee_plan_rule_stage` `bfprs` ON ((`bh`.`id` = `bfprs`.`billId`)))
        left join `academy_location` `al` ON ((`bh`.`academyLocationId` = `al`.`id`)))
        left join `academies` `ac` ON ((`al`.`academyId` = `ac`.`id`)))
        left join `locations` `lc` ON ((`al`.`locationId` = `lc`.`id`)))
        left join `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `bh`.`programBatchSeatConfigId`)))
        left join `batches` `b` ON ((`pbsc`.`programBatchId` = `b`.`id`)))
        left join `programs` `p` ON ((`b`.`programId` = `p`.`id`)))
        left join `intake_year` `iy` ON ((`b`.`intakeYearId` = `iy`.`id`)))
        left join `application` `app` ON ((`bh`.`applicantId` = `app`.`id`)))
        left join `applicant_person` `ap` ON ((`app`.`applicantPersonId` = `ap`.`id`)))
    where
        ((`bh`.`applicantId` is not null)
            and (`bh`.`billStatus` <> 'CANCELLED')
            and (`bh`.`raiseBillCategory` = 'BILL_RECEIVABLE'))
    group by `app`.`id` , `al`.`id`;
END IF; 

END $$
CALL V20200402143024__Create_application_fee_view () $$ 
DROP PROCEDURE IF EXISTS V20200402143024__Create_application_fee_view $$ 
DELIMITER ;