DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402150834__Create_user_login_history_view $$
CREATE PROCEDURE V20200402150834__Create_user_login_history_view()
BEGIN


IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'user_login_history_view')) THEN 
DROP view `user_login_history_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'user_login_history_view')) THEN 
CREATE OR REPLACE VIEW `user_login_history_view` AS
    select
        `u`.`code` AS `code`,
        `u`.`printName` AS `User`,
        `ug`.`userGroupName` AS `UserGroup`,
        `al`.`academyName` AS `Academy Name`,
        `al`.`locationName` AS `Location`,
	`al`.`id` AS `Academy Location Id`,
        (case
            when (`u`.`status` = 1) then 'Active'
            else 'Inactive'
        end) AS `Status`,
        `ulh`.`userId` AS `Session`,
        `ulh`.`whetherTimeout` AS `Auto logout`,
        `u`.`totalLoginFailed` AS `Failed Login`,
        `ulh`.`browserName` AS `Browser`,
        `ulh`.`loginDeviceName` AS `Login Device`,
        `ulh`.`timeSpent` AS `Time Spent`,
        date_format(`ulh`.`loginTime`, '%d/%m/%Y') AS `Login Date`,
        date_format(`ulh`.`logoutTime`, '%d/%m/%Y') AS `Logout Date`,
        cast(`ulh`.`loginTime` as time) AS `Login Time`,
        cast(`ulh`.`logoutTime` as time) AS `Logout Time`
    from
        (((((`user_login_history` `ulh`
        join `users` `u` ON ((`u`.`id` = `ulh`.`userId`)))
        join `user_groups` `ug` ON ((`ug`.`id` = `u`.`userGroupId`)))
        left join `user_academy_locations` `ual` ON ((`ual`.`userId` = `u`.`id`)))
        left join `academy_location` `al` ON ((`al`.`id` = `ual`.`academyLocationId`)))
        left join `user_acad_loc_roles` `ualr` ON ((`ualr`.`userAcadLocationId` = `ual`.`id`)))
    group by `ulh`.`loginTime`;
END IF; 

END $$
CALL V20200402150834__Create_user_login_history_view () $$ 
DROP PROCEDURE IF EXISTS V20200402150834__Create_user_login_history_view $$ 
DELIMITER ;