DELIMITER $$
DROP PROCEDURE IF EXISTS V20200407120650__Create_customFieldConfigPortal $$
CREATE PROCEDURE V20200407120650__Create_customFieldConfigPortal()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='custom_field_config_portal')) THEN 
CREATE TABLE custom_field_config_portal (
    id BIGINT(20) AUTO_INCREMENT primary key,
    applicant_portal_setup_id BIGINT(20) DEFAULT NULL,
    applicant_portal_module_id BIGINT(20) DEFAULT NULL,
    custom_field_config_id BIGINT(20) DEFAULT NULL,
    whether_custom_field BIT(1) DEFAULT NULL,
    is_visible TINYINT(1) DEFAULT NULL,
    is_mandatory TINYINT(1) DEFAULT NULL,
    lastUpdate  TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
    FOREIGN KEY (applicant_portal_setup_id)
        REFERENCES applicant_portal_setup (id),
    FOREIGN KEY (applicant_portal_module_id)
        REFERENCES applicant_portal_modules (id),
    FOREIGN KEY (custom_field_config_id)
        REFERENCES custom_field_config (id),
    FOREIGN KEY (lastUpdatedBy)
        REFERENCES users (id)
);
END IF; 

END $$
CALL V20200407120650__Create_customFieldConfigPortal () $$ 
DROP PROCEDURE IF EXISTS V20200407120650__Create_customFieldConfigPortal $$ 
DELIMITER ;