DELIMITER $$
DROP PROCEDURE IF EXISTS V20200507125438__Alter_standardMasterItem $$
CREATE PROCEDURE V20200507125438__Alter_standardMasterItem()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='standard_master')) THEN 
SET @smId=(SELECT id FROM standard_master WHERE tableName LIKE 'invt_type_master%' LIMIT 1);
DELETE FROM standard_master_items WHERE standardMasterId IN (@smId);
DELETE FROM standard_master WHERE id IN (@smId);


INSERT INTO `standard_master` (`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `displayValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('invt_type_master', 'INVT_TYPE_MASTER', 'Program & Courses', 'COMMON_MASTER', 0, 0, 'Course Resource Type', '1', SYSDATE());

SET @standardMasterMaxId=(SELECT id FROM standard_master  WHERE tableName LIKE 'invt_type_master%' LIMIT 1);
END IF; 

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 

INSERT INTO standard_master_items( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES ('inventoryType', 'COURSE_RESOURCE_TYPE', @standardMasterMaxId , 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('readingMaterial', 'READING_MATERIAL', @standardMasterMaxId, 'Boolean', '2', 0, 0, 0, 0, '1', SYSDATE());
END IF; 

END $$
CALL V20200507125438__Alter_standardMasterItem() $$
DROP PROCEDURE IF EXISTS V20200507125438__Alter_standardMasterItem $$
DELIMITER ;