DELIMITER $$

DROP PROCEDURE IF EXISTS V20200519151305__AlterDataRequirement $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200519151305__AlterDataRequirement()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' 
  AND column_name='exam_passed_id')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup` ADD COLUMN `exam_passed_id` BIGINT(20) NULL AFTER `applicant_portal_module_id`;

	set foreign_key_checks=0;
	ALTER TABLE `data_requirement_setup` 
	ADD CONSTRAINT `requirement_fk_exam_passed_id`
	FOREIGN KEY (`exam_passed_id`)
	REFERENCES `exam_passed` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' 
  AND column_name='competitive_exam_id')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup` ADD COLUMN `competitive_exam_id` BIGINT(20) NULL AFTER `exam_passed_id`;

	set foreign_key_checks=0;
	ALTER TABLE `data_requirement_setup` 
	ADD CONSTRAINT `requirement_fk_competitive_exam_id`
	FOREIGN KEY (`competitive_exam_id`)
	REFERENCES `examination_name` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' 
  AND column_name='parent_guardian')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup` ADD COLUMN `parent_guardian` VARCHAR(50) NULL AFTER `competitive_exam_id`;
  
  END IF;
  
  IF EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup' 
  AND column_name='exam_pass')) THEN
  
    ALTER TABLE data_requirement_setup DROP exam_pass;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V20200519151305__AlterDataRequirement $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200519151305__AlterDataRequirement $$
 
DELIMITER ;