DELIMITER $$
DROP PROCEDURE IF EXISTS V20200520123243__Insert_InsertReadingMaterial $$
CREATE PROCEDURE V20200520123243__Insert_InsertReadingMaterial()
BEGIN


IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'READING_MATERIAL_REPORT' )) THEN 

INSERT INTO `report_template`(`reportTypeId`,`templateCode`,`templateName`,`imageLocation`,`jasperFileLocation`,`documentTypes`,`whetherDefault`,`headerJasperFileLocation`,`footerJasperFileLocation`,`repeatHeaderOnAllPages`,`repeatFooterOnAllPages`,`bodyJasperFileLocation`,`defaultHeaderLogo`)
VALUES ('10','READING_MATERIAL_REPORT','Reading Material Report','READING_MATERIAL_REPORT.png','ReadingMaterial_CommonReport_Excel.jasper','All','1','ReadingMaterial_Header.jasper','ReadingMaterial_Footer.jasper','1','1','READING_MATERIAL_REPORT.jasper','AcademiaLogo.png');

set @readingMaterial = (select max(id) from report_template where templateCode ='READING_MATERIAL_REPORT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@readingMaterial, 'TRANS_REPORT_NAME', 'Reading Material Report', '1', NOW()),
(@readingMaterial, 'TRANS_ACADEMIC_TERM', 'Academic Term', '1', NOW()),
(@readingMaterial, 'TRANS_COURSE_DEPT', 'Course Department', '1', NOW()),
(@readingMaterial, 'TRANS_COURSE_CODE', 'Course Code / Name', '1', NOW()),
(@readingMaterial, 'TRANS_USER_REQ_FOR', 'User Requested By', '1', NOW()),
(@readingMaterial, 'TRANS_PHONE_NUMBER', 'Phone Number', '1', NOW()),
(@readingMaterial, 'TRANS_WORK_EMAIL', 'Work Email', '1', NOW()),
(@readingMaterial, 'TRANS_READING_NAME', 'Reading Name', '1', NOW()),
(@readingMaterial, 'TRANS_FIRST_AUTHOR', 'First Author', '1', NOW()),
(@readingMaterial, 'TRANS_ISBN_10', 'ISBN-10', '1', NOW()),
(@readingMaterial, 'TRANS_ISBN_13', 'ISBN-13', '1', NOW()),
(@readingMaterial, 'TRANS_BINDING', 'Binding', '1', NOW()),
(@readingMaterial, 'TRANS_ISSUE_YEAR', 'Issue Year', '1', NOW()),
(@readingMaterial, 'TRANS_ISSUED_NUMBER', 'Issued Number', '1', NOW()),
(@readingMaterial, 'TRANS_PUBLISHER', 'Publisher', '1', NOW()),
(@readingMaterial, 'TRANS_DATE_REQUIRED', 'Date Required', '1', NOW()),
(@readingMaterial, 'TRANS_YEAR_PHASED_OUT', 'Year Phased Out', '1', NOW());
END IF; 

END $$
CALL V20200520123243__Insert_InsertReadingMaterial() $$
DROP PROCEDURE IF EXISTS V20200520123243__Insert_InsertReadingMaterial $$
DELIMITER ;
