DELIMITER $$
DROP PROCEDURE IF EXISTS V20200526133643__Create_Payment_Plan_Doc $$
CREATE PROCEDURE V20200526133643__Create_Payment_Plan_Doc()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_plan_doc')) THEN 
CREATE TABLE `payment_plan_doc` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `documentId` BIGINT NOT NULL,
  `paymentPlanId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_payment_plan_doc_to_documents_idx` (`documentId` ASC),
  INDEX `fk_payment_plan_doc_to_payment_plan_idx` (`paymentPlanId` ASC),
  INDEX `fk_payment_plan_doc_to_user_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_payment_plan_doc_to_documents`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_doc_to_payment_plan`
    FOREIGN KEY (`paymentPlanId`)
    REFERENCES `payment_plan` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_doc_to_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200526133643__Create_Payment_Plan_Doc () $$ 
DROP PROCEDURE IF EXISTS V20200526133643__Create_Payment_Plan_Doc $$ 
DELIMITER ;