DELIMITER $$
DROP PROCEDURE IF EXISTS V20200618163043__Create_Learning_Target_Details $$
CREATE PROCEDURE V20200618163043__Create_Learning_Target_Details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_target_details' )) THEN 

CREATE TABLE `learning_target_details` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `learningTargetId` BIGINT NOT NULL,
  `courseId` BIGINT NOT NULL,
  `targetGradeMarks` VARCHAR(255) NULL DEFAULT NULL,
  `targetAttendance` VARCHAR(20) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_learning_target_details_learningTargetId_idx` (`learningTargetId` ASC),
  INDEX `fk_learning_target_details_courseId_idx` (`courseId` ASC),
  INDEX `fk_learning_target_details_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_learning_target_details_learningTargetId`
    FOREIGN KEY (`learningTargetId`)
    REFERENCES `learning_target` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_learning_target_details_courseId`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_learning_target_details_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);


END IF; 

END $$
CALL V20200618163043__Create_Learning_Target_Details () $$ 
DROP PROCEDURE IF EXISTS V20200618163043__Create_Learning_Target_Details $$ 
DELIMITER ;