DELIMITER $$
DROP PROCEDURE IF EXISTS V20200715145252__Create_EmployeeJobPosting $$
CREATE PROCEDURE V20200715145252__Create_EmployeeJobPosting()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_job_posting')) THEN 
CREATE TABLE `employee_job_posting` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `jobCode` char(100) DEFAULT NULL,
  `jobTitle` varchar(255) DEFAULT NULL,
  `jobDescription` varchar(255) DEFAULT NULL,
  `coordinator` bigint(20) DEFAULT NULL,
  `userGroup` BIGINT(20) DEFAULT NULL,
  `facultyType` BIGINT(20) DEFAULT NULL,
  `fromDate` datetime DEFAULT NULL,
  `toDate` datetime DEFAULT NULL,
  `status` bit(1) DEFAULT NULL,
  `publishStatus` varchar(25) DEFAULT NULL,
  `mappingStatus` varchar(25) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_coordinator_idx` (`coordinator`),
  KEY `fk_usergroup_idx` (`userGroup`),
  KEY `fk_facultyType_idx` (`facultyType`),
  KEY `fk_lastupdatedby_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_coordinator` FOREIGN KEY (`coordinator`) REFERENCES `staffs` (`userid`),
  CONSTRAINT `fk_facultyType` FOREIGN KEY (`facultyType`) REFERENCES `faculty_type` (`id`),
  CONSTRAINT `fk_lastupdatedby_job` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_usergroup` FOREIGN KEY (`userGroup`) REFERENCES `user_groups` (`id`)
);
END IF; 

END $$
CALL V20200715145252__Create_EmployeeJobPosting () $$ 
DROP PROCEDURE IF EXISTS V20200715145252__Create_EmployeeJobPosting $$ 
DELIMITER ;