DELIMITER $$
DROP PROCEDURE IF EXISTS V20200728132232__Create_FacultyNonAcademicAchievements $$
CREATE PROCEDURE V20200728132232__Create_FacultyNonAcademicAchievements()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='faculty_non_academic_achievements')) THEN 
CREATE TABLE `faculty_non_academic_achievements` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `sportEventsId` BIGINT(20) NULL,
  `levelEventsId` BIGINT(20) NULL,
  `applicant_persons_id` BIGINT(20) NULL,
  `persons_id` BIGINT(20) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ,
  `lastUpdatedBy` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `person_id_idx` (`persons_id` ASC),
  INDEX `applicant_person_id_idx` (`applicant_persons_id` ASC),
  INDEX `levelEventId_idx` (`levelEventsId` ASC),
  INDEX `sportEventId_idx` (`sportEventsId` ASC),
  CONSTRAINT `sportEventsId`
    FOREIGN KEY (`sportEventsId`)
    REFERENCES `drop_down`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `levelEventsId`
    FOREIGN KEY (`levelEventsId`)
    REFERENCES `drop_down`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `applicant_persons_id`
    FOREIGN KEY (`applicant_persons_id`)
    REFERENCES `applicant_person`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `persons_id`
    FOREIGN KEY (`persons_id`)
    REFERENCES `persons`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200728132232__Create_FacultyNonAcademicAchievements () $$ 
DROP PROCEDURE IF EXISTS V20200728132232__Create_FacultyNonAcademicAchievements $$ 
DELIMITER ;
