DELIMITER $$
DROP PROCEDURE IF EXISTS V20200807103131__Create_BatchCourseRequisites $$
CREATE PROCEDURE V20200807103131__Create_BatchCourseRequisites()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='batch_course_requisites')) THEN 
CREATE TABLE `batch_course_requisites` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `batchCourseId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `courseRelation` varchar(45) NOT NULL,
  `relatedCourseId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_batch_course_requisites_1_idx` (`courseId`),
  KEY `fk_batch_course_requisites_2_idx` (`relatedCourseId`),
  KEY `fk_batch_course_requisites_3_idx` (`lastUpdatedBy`),
  KEY `fk_batch_course_requisites_4_idx` (`batchCourseId`),
  CONSTRAINT `fk_batch_course_requisites_1` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_batch_course_requisites_2` FOREIGN KEY (`relatedCourseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_batch_course_requisites_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_batch_course_requisites_4` FOREIGN KEY (`batchCourseId`) REFERENCES `batch_courses` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;	
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='batch_course_requisite_criteria')) THEN 
CREATE TABLE `batch_course_requisite_criteria` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `batchCourseRequisiteId` bigint(20) DEFAULT NULL,
  `logicalOperator` varchar(45) DEFAULT NULL,
  `criteriaType` varchar(45) DEFAULT NULL,
  `courseRelationType` varchar(45) DEFAULT NULL,
  `courseRelationOperand` varchar(45) DEFAULT NULL,
  `parentId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `restrictionValue` varchar(45) DEFAULT NULL,
  `examPassedId` bigint(20) DEFAULT NULL,
  `resultStatusId` bigint(20) DEFAULT NULL,
  `subjectId` bigint(20) DEFAULT NULL,
  `educationFields` varchar(45) DEFAULT NULL,
  `monthValid` varchar(45) DEFAULT NULL,
  `scoreMethod` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_batch_course_requisites_criteria_criteria_1_idx` (`batchCourseRequisiteId`),
  KEY `fk_batch_course_requisites_criteria_2_idx` (`parentId`),
  KEY `fk_batch_course_requisites_criteria_3_idx` (`lastUpdatedBy`),
  KEY `fk_batch_course_requisites_criteria_4` (`courseId`),
  KEY `fk_batch_course_requisites_criteria_6` (`subjectId`),
  KEY `fk_batch_course_requisites_criteria_5_idx` (`examPassedId`),
  KEY `fk_batch_course_requisites_criteria_7_idx` (`resultStatusId`),
  CONSTRAINT `fk_batch_course_requisites_criteria_1` FOREIGN KEY (`batchCourseRequisiteId`) REFERENCES `batch_course_requisites` (`id`),
  CONSTRAINT `fk_batch_course_requisites_criteria_2` FOREIGN KEY (`parentId`) REFERENCES `batch_course_requisite_criteria` (`id`),
  CONSTRAINT `fk_batch_course_requisites_criteria_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_batch_course_requisites_criteria_4` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_batch_course_requisites_criteria_5` FOREIGN KEY (`examPassedId`) REFERENCES `exam_passed` (`id`),
  CONSTRAINT `fk_batch_course_requisites_criteria_6` FOREIGN KEY (`subjectId`) REFERENCES `subjects` (`id`),
  CONSTRAINT `fk_batch_course_requisites_criteria_7` FOREIGN KEY (`resultStatusId`) REFERENCES `result_status` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;
	
END IF; 

END $$
CALL V20200807103131__Create_BatchCourseRequisites () $$ 
DROP PROCEDURE IF EXISTS V20200807103131__Create_BatchCourseRequisites $$ 
DELIMITER ;