DELIMITER $$

DROP PROCEDURE IF EXISTS V20200807110535__InsertUITRNSForFeePyerPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200807110535__InsertUITRNSForFeePyerPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DOES_FEE_PAYER_CONSENT_TO_CREDIT_CHECK')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','DOES_FEE_PAYER_CONSENT_TO_CREDIT_CHECK','Does Fee Payer Consent to Credit Check','Does Fee Payer Consent to Credit Check','Toestemming van die betaalnemer tot kredietkontrole', 'Người trả phí có đồng ý kiểm tra tín dụng không',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='HOME_TELEPHONE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','HOME_TELEPHONE','Home Telephone','Home Telephone','Huistelefoon', 'Điện thoại gia đình',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FEE_PAYER_ID')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','FEE_PAYER_ID','Fee Payer ID','Fee Payer ID','Fooi Betaler ID', 'ID người trả phí',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FEE_PAYER_LATEST_PAYSLIP')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FEE_PAYER_LATEST_PAYSLIP','Fee Payer Latest Slip','Fee Payer Latest Slip','Fooi Betaler nuutste strokie', 'Người trả phí trượt mới nhất',now(),1);
END IF;
 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EMAIL_HOME_USE_FOR_COMMUNICATION')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','EMAIL_HOME_USE_FOR_COMMUNICATION','User This for Communication ?','User This for Communication ?','Gebruiker vir kommunikasie?', 'Người dùng này để liên lạc?',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='UPLOAD_MANDATORY_DOCUMENT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','UPLOAD_MANDATORY_DOCUMENT','Please Upload all mandatory document','Please Upload all mandatory document','Laai asseblief al die verpligte dokumente op', 'Vui lòng tải lên tất cả tài liệu bắt buộc',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PBS_TYPE_ASSOCIATED')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PBS_TYPE_ASSOCIATED','Program Batch Seat Type Associated','Program Batch Seat Type Associated','Programgroep sitplektipe geassosieer', 'Liên kết loại ghế theo lô chương trình',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DOCUMENT_VIEW')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DOCUMENT_VIEW','Document View','Document View','Dokumentaansig', 'Dokumentaansig',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EMAIL_HOME')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FEE_EMAIL_HOME','Email (Home)','Email (Home)','E-pos (tuis)', 'Email (Trang chủ)',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EMAIL_WORK')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FEE_EMAIL_WORK','Email (Work)','Email (Work)','E-pos (werk)', 'Email (Cơ quan)',now(),1);
END IF;

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EMAIL_HOME_USE_FOR_COMMUNICATION')) THEN 
update `ui_translation`
set defaultValue = 'Use This for Communication ?',
customerDefineValue = 'Use This for Communication ?',
afriLanguage = 'Gebruik u dit vir kommunikasie?',
vietLanguage = 'Sử dụng cái này để liên lạc?'
where objectName='PORTAL_SETUP_NEW' and keyName='EMAIL_HOME_USE_FOR_COMMUNICATION';
END IF; 
SET SQL_SAFE_UPDATES=1;
 
END $$

-- Execute the stored procedure
CALL V20200807110535__InsertUITRNSForFeePyerPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200807110535__InsertUITRNSForFeePyerPortal $$
 
DELIMITER ;