DELIMITER $$
DROP PROCEDURE IF EXISTS V20200812193943__Create_DocumentGroupMasterLocation $$
CREATE PROCEDURE V20200812193943__Create_DocumentGroupMasterLocation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='document_group_master_location')) THEN 
CREATE TABLE `document_group_master_location` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `documentGroupMasterId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 INDEX `fk_dgml_dgm_id_idx` (`documentGroupMasterId` ASC),
 INDEX `fk_dgml_al_id_idx` (`academyLocationId` ASC),
 INDEX `fk_dgml_user_id_idx` (`lastUpdatedBy` ASC),
 CONSTRAINT `fk_dgml_dgm_id`
    FOREIGN KEY (documentGroupMasterId)
    REFERENCES `document_group_master` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
 CONSTRAINT `fk_dgml_al_id`
    FOREIGN KEY (academyLocationId)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
 CONSTRAINT `fk_dgml_user_id`
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200812193943__Create_DocumentGroupMasterLocation () $$ 
DROP PROCEDURE IF EXISTS V20200812193943__Create_DocumentGroupMasterLocation $$ 
DELIMITER ;