DELIMITER $$

DROP PROCEDURE IF EXISTS V20200814200405__InsertUITranForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200814200405__InsertUITranForPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROGRAM_CANT_ADD')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PROGRAM_CANT_ADD','Program can not add please contact to admin','Program can not add please contact to admin', 'Program kan nie byvoeg nie, kontak asseblief met admin','Chương trình không thể thêm vui lòng liên hệ với quản trị viên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROVISIONAL_OFFER_LETTER')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PROVISIONAL_OFFER_LETTER','Provisional Offer Letter','Provisional Offer Letter', 'Voorlopige aanbiedingsbrief','Yêu cầu xác minh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROVISIONAL_OFFER_LETTER_ISSUE_DATE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PROVISIONAL_OFFER_LETTER_ISSUE_DATE','Provisional Offer Letter Issue Date','Provisional Offer Letter Issue Date', 'Voorlopige aanbodbrief Datum van uitreiking','Yêu cầu xác minh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROVISIONAL_OFFER_LETTER_WILL_EXPIRE_IN')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PROVISIONAL_OFFER_LETTER_WILL_EXPIRE_IN','Provisional Offer Letter will Expire In','Provisional Offer Letter will Expire In', 'Die voorlopige aanbiedingsbrief sal verval in','Thư mời chào tạm thời sẽ hết hạn sau',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FINAL_OFFER_LETTER_ISSUE_DATE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FINAL_OFFER_LETTER_ISSUE_DATE','Final Offer Letter Issue Date','Final Offer Letter Issue Date', 'Finale aanbiedingsbrief Datum van uitreiking','Ngày phát hành thư chào hàng cuối cùng',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FINAL_OFFER_LETTER_WILL_EXPIRE_IN')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FINAL_OFFER_LETTER_WILL_EXPIRE_IN','Final Offer Letter will Expire In','Final Offer Letter will Expire In', 'Finale aanbiedingsbrief sal verval in','Thư mời chào cuối cùng sẽ hết hạn sau',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_PROVISIONAL_OFFER_LETTER')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ACCEPT_PROVISIONAL_OFFER_LETTER','Accept Provisional Offer Letter','Accept Provisional Offer Letter', 'Aanvaar die voorlopige aanbiedingsbrief','Chấp nhận Thư đề nghị Tạm thời',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_PROVISIONAL_OFFER_LETTER')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DECLINE_PROVISIONAL_OFFER_LETTER','Decline Provisional Offer Letter','Decline Provisional Offer Letter', 'Weier om voorlopige aanbiedingsbrief','Từ chối Thư đề nghị Tạm thời',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_FINAL_OFFER_LETTER')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ACCEPT_FINAL_OFFER_LETTER','Accept Final Offer Letter','Accept Final Offer Letter', 'Aanvaar die finale aanbiedingsbrief','Chấp nhận thư mời cuối cùng',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_FINAL_OFFER_LETTER')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DECLINE_FINAL_OFFER_LETTER','Decline Final Offer Letter','Decline Final Offer Letter', 'Weier om die finale aanbiedingsbrief','Từ chối Thư đề nghị Cuối cùng',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_FINAL_OFFER_CONFIRM_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ACCEPT_FINAL_OFFER_CONFIRM_MSG','Are you sure, you want to Accept offer letter ?','Are you sure, you want to Accept offer letter ?', 
		'Is u seker dat u die aanbodbrief wil aanvaar?','Bạn có chắc chắn muốn Chấp nhận thư mời nhập học không?',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_FINAL_OFFER_CONFIRM_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DECLINE_FINAL_OFFER_CONFIRM_MSG','Are you sure, you want to Decline offer letter ?','Are you sure, you want to Decline offer letter ?', 'Is u seker dat u die aanbodbrief wil weier?','Yêu cầu xác minh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_PROVISIONAL_OFFER_CONFIRM_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ACCEPT_PROVISIONAL_OFFER_CONFIRM_MSG','Are you sure, you want to Accept offer letter ?','Are you sure, you want to Accept offer letter ?', 'Is u seker dat u die aanbodbrief wil aanvaar?','Bạn có chắc chắn muốn Chấp nhận thư mời nhập học không?',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_PROVISIONAL_OFFER_CONFIRM_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DECLINE_PROVISIONAL_OFFER_CONFIRM_MSG','Are you sure, you want to Decline offer letter ?','Are you sure, you want to Decline offer letter ?', 'Is u seker dat u die aanbodbrief wil weier?','Bạn có chắc chắn muốn Từ chối thư mời không?',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_FINAL_OFFER_SUCCESS_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ACCEPT_FINAL_OFFER_SUCCESS_MSG','Offer Accepted Successfully','Offer Accepted Successfully', 'Aanbieding suksesvol aanvaar','Phiếu mua hàng được chấp nhận thành công',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_FINAL_OFFER_SUCCESS_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DECLINE_FINAL_OFFER_SUCCESS_MSG','Offer Declined Successfully','Offer Declined Successfully', 'Aanbieding suksesvol geweier','Phiếu mua hàng đã từ chối thành công',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_PROVISIONAL_OFFER_SUCCESS_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ACCEPT_PROVISIONAL_OFFER_SUCCESS_MSG','Provisional Offer Accepted Successfully','Provisional Offer Accepted Successfully', 'Voorlopige aanbod suksesvol aanvaar','Ưu đãi Tạm thời được Chấp nhận Thành công',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_PROVISIONAL_OFFER_SUCCESS_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DECLINE_PROVISIONAL_OFFER_SUCCESS_MSG',' Provisional Offer Declined Successfully','Provisional Offer Declined Successfully', 'Die voorlopige aanbod is suksesvol afgekeur','Phiếu mua hàng tạm thời đã bị từ chối thành công',now(),1);
END IF;

 
END $$

-- Execute the stored procedure
CALL V20200814200405__InsertUITranForPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200814200405__InsertUITranForPortal $$
 
DELIMITER ;