DELIMITER $$
DROP PROCEDURE IF EXISTS V20200911204053__Create_alterCampaignReportView $$
CREATE PROCEDURE V20200911204053__Create_alterCampaignReportView()
BEGIN

DROP VIEW IF EXISTS campaign_report;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='campaign_report')) THEN 
Create VIEW `campaign_report` AS
    SELECT 
        `campaign`.`id` AS `campaignId`,
        `campaign`.`code` AS `campaignCode`,
        `campaign`.`campaignName` AS `campaignName`,
        `campaign`.`fromDate` AS `fromDate`,
        `campaign`.`toDate` AS `toDate`,
        `campaign_coverage`.`academyLocationId` AS `academyLocationId`,
        (TO_DAYS(CURDATE()) - TO_DAYS(`campaign`.`fromDate`)) AS `noOfDayActive`,
        (TO_DAYS(`campaign`.`toDate`) - TO_DAYS(`campaign`.`fromDate`)) AS `totalDuration`,
        IF(ISNULL(`campaign`.`actualAmount`),
            `campaign`.`budgetAmount`,
            `campaign`.`actualAmount`) AS `costCampaign`,
        COUNT(DISTINCT `enquiry`.`id`) AS `totalEnquiry`,
        (SELECT 
                COUNT(`application`.`id`)
            FROM
                `application`
            WHERE
                `application`.`enquiryStudentDetailId` IN (SELECT 
                        `admission_enq_details`.`enqStudentDetailsId`
                    FROM
                        ((`enquiry`
                        JOIN `enq_student_details` ON ((`enq_student_details`.`enquiryId` = `enquiry`.`id`)))
                        JOIN `admission_enq_details` ON ((`admission_enq_details`.`enqStudentDetailsId` = `enq_student_details`.`id`)))
                    WHERE
                        (`enquiry`.`campaignId` = `campaign`.`id`))) AS `noOfApplications`,
        (SELECT 
                COUNT(DISTINCT `academies`.`id`)
            FROM
                (((`campaign_coverage`
                LEFT JOIN `academy_location` ON ((`academy_location`.`id` = `campaign_coverage`.`academyLocationId`)))
                LEFT JOIN `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                LEFT JOIN `campaign` `cmp` ON ((`campaign_coverage`.`campaignId` = `cmp`.`id`)))
            WHERE
                (`cmp`.`id` = `campaign`.`id`)
            GROUP BY `campaign_coverage`.`campaignId`) AS `academiesCovered`,
        (SELECT 
                COUNT(DISTINCT `locations`.`id`)
            FROM
                (((`campaign_coverage`
                LEFT JOIN `academy_location` ON ((`campaign_coverage`.`academyLocationId` = `academy_location`.`id`)))
                LEFT JOIN `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                LEFT JOIN `campaign` `cmp` ON ((`campaign_coverage`.`campaignId` = `cmp`.`id`)))
            WHERE
                (`cmp`.`id` = `campaign`.`id`)
            GROUP BY `campaign_coverage`.`campaignId`) AS `locationsCovered`,
        (SELECT 
                COUNT(DISTINCT `programs`.`id`)
            FROM
                ((`campaign_coverage`
                LEFT JOIN `programs` ON ((`campaign_coverage`.`programId` = `programs`.`id`)))
                LEFT JOIN `campaign` `cmp` ON ((`campaign_coverage`.`campaignId` = `cmp`.`id`)) and `campaign_coverage`.`whetherDeleted`=false)
            WHERE
                (`cmp`.`id` = `campaign`.`id`)
            GROUP BY `campaign_coverage`.`campaignId`) AS `programsCovered`,
        (IF(ISNULL(`campaign`.`actualAmount`),
            `campaign`.`budgetAmount`,
            `campaign`.`actualAmount`) / COUNT(DISTINCT `enquiry`.`id`)) AS `costPerEnquiry`,
        (SELECT 
                COUNT(`application`.`enquiryStudentDetailId`)
            FROM
                (((`application`
                LEFT JOIN `enq_student_details` ON ((`application`.`enquiryStudentDetailId` = `enq_student_details`.`id`)))
                LEFT JOIN `enquiry` ON ((`enq_student_details`.`enquiryId` = `enquiry`.`id`)))
                LEFT JOIN `campaign` `camp` ON ((`enquiry`.`campaignId` = `camp`.`id`)))
            WHERE
                ((`camp`.`id` = `campaign`.`id`)
                    AND (`application`.`currentStatus` = 'ADMISSION_GRANTED'))) AS `studentAdmitted`,
        (SELECT 
                COUNT(DISTINCT `application`.`enquiryStudentDetailId`)
            FROM
                ((((`application`
                LEFT JOIN `enq_student_details` ON ((`application`.`enquiryStudentDetailId` = `enq_student_details`.`id`)))
                LEFT JOIN `enquiry` ON ((`enq_student_details`.`enquiryId` = `enquiry`.`id`)))
                LEFT JOIN `campaign` `camp` ON ((`enquiry`.`campaignId` = `camp`.`id`)))
                LEFT JOIN `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
            WHERE
                ((`camp`.`id` = `campaign`.`id`)
                    AND (`application_program`.`currentStatus` = 'OFFER_LETTER_ACCEPTED')
                    AND (`application`.`currentStatus` <> 'ADMISSION_GRANTED'))) AS `studentSelected`,
        ((SELECT 
                IF(ISNULL(`campa`.`actualAmount`),
                        `campa`.`budgetAmount`,
                        `campa`.`actualAmount`)
            FROM
                `campaign` `campa`
            WHERE
                (`campaign`.`id` = `campa`.`id`)) / (SELECT 
                COUNT(`application`.`enquiryStudentDetailId`)
            FROM
                (((`application`
                LEFT JOIN `enq_student_details` ON ((`application`.`enquiryStudentDetailId` = `enq_student_details`.`id`)))
                LEFT JOIN `enquiry` ON ((`enq_student_details`.`enquiryId` = `enquiry`.`id`)))
                LEFT JOIN `campaign` `camp` ON ((`enquiry`.`campaignId` = `camp`.`id`)))
            WHERE
                ((`campaign`.`id` = `camp`.`id`)
                    AND (`application`.`currentStatus` = 'ADMISSION_GRANTED')))) AS `costPerAdmission`
    FROM
        (((((`campaign`
        LEFT JOIN `enquiry` ON ((`enquiry`.`campaignId` = `campaign`.`id`)))
        LEFT JOIN `enq_student_details` ON ((`enquiry`.`id` = `enq_student_details`.`enquiryId`)))
        LEFT JOIN `application` ON ((`enq_student_details`.`id` = `application`.`enquiryStudentDetailId`)))
        LEFT JOIN `admission_enq_details` ON ((`enq_student_details`.`id` = `admission_enq_details`.`enqStudentDetailsId`)))
        LEFT JOIN `campaign_coverage` ON ((`campaign_coverage`.`campaignId` = `campaign`.`id`)))
        LEFT JOIN `enquiry_type` ON ((`enquiry`.`enquiryTypeId` = `enquiry_type`.`id`))
    WHERE
        ((`campaign`.`whetherDeleted` = 0)
            AND (`enquiry_type`.`code` = 'Admission'))
    GROUP BY `campaign`.`id` , `campaign_coverage`.`academyLocationId`
    ORDER BY `campaign`.`fromDate`;
END IF; 

END $$
CALL V20200911204053__Create_alterCampaignReportView () $$ 
DROP PROCEDURE IF EXISTS V20200911204053__Create_alterCampaignReportView $$ 
DELIMITER ;
