DELIMITER $$

DROP PROCEDURE IF EXISTS V20201007143600__AlterPersonAddMaritalColumn $$

CREATE PROCEDURE V20201007143600__AlterPersonAddMaritalColumn()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='marital_status_id')) THEN 
	  ALTER TABLE `persons` 
	  ADD COLUMN `marital_status_id` BIGINT(20) NULL DEFAULT NULL,
	  ADD INDEX `fk_person_marital_status_idx` (`marital_status_id` ASC);
	
		set foreign_key_checks=0;
		ALTER TABLE `persons` 
		ADD CONSTRAINT `fk_persons_marital_status_id`
		FOREIGN KEY (`marital_status_id`)
		REFERENCES `marital_status` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION;
		set foreign_key_checks=1;
	
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='marital_status_id')) THEN 
	ALTER TABLE `applicant_person` 
	ADD COLUMN `marital_status_id` BIGINT(20) NULL DEFAULT NULL,
	ADD INDEX `fk_person_marital_status_idx` (`marital_status_id` ASC);
	
		set foreign_key_checks=0;
		ALTER TABLE `applicant_person` 
		ADD CONSTRAINT `fk_applicant_person_marital_status_id`
		FOREIGN KEY (`marital_status_id`)
		REFERENCES `marital_status` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION;
		set foreign_key_checks=1;
	
	END IF;


END $$

CALL V20201007143600__AlterPersonAddMaritalColumn() $$

DROP PROCEDURE IF EXISTS V20201007143600__AlterPersonAddMaritalColumn $$

DELIMITER ;