DELIMITER $$
DROP PROCEDURE IF EXISTS V20201027162629__Create_FeeAndPaymentViewsForSAPB1 $$
CREATE PROCEDURE V20201027162629__Create_FeeAndPaymentViewsForSAPB1()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='debit_note_view_sapb1')) THEN 
CREATE VIEW debit_note_view_sapb1 AS
    SELECT 
        bfprs.id AS DebitNoteFeeHeadId,
        bh.billNo AS DebitNoteNo,
        bh.raiseBillType AS DebitNoteType,
        but.billedUserType AS DebitNoteFor,
        c.currencyCode AS DebitNoteCurrency,
        bh.billingDate AS DebitNoteDate,
        CASE
            WHEN bh.applicantId IS NOT NULL THEN CONCAT(a.code, '/', ap.printName)
            WHEN bh.studentId IS NOT NULL THEN CONCAT(st_user.code, '/', st_user.printName)
            WHEN bh.sponsorId IS NOT NULL THEN CONCAT(sp.sponsorshipCode, '/', sp.sponsorName)
            WHEN bh.userId IS NOT NULL THEN CONCAT(u.code, '/', u.printName)
            ELSE NULL
        END AS DebitNoteOwner,
        (SELECT 
                pbpc.programPeriodName
            FROM
                program_batch_students pbs
                    LEFT OUTER JOIN
                prog_batch_period_config pbpc ON pbs.progBatchPeriodConfigId = pbpc.id
                    LEFT OUTER JOIN
                admission adm ON adm.id = pbs.admissionId
                    LEFT OUTER JOIN
                students st ON st.userId = adm.studentId
            WHERE
                st.userId = bh.studentId
                    AND bh.billingDate >= pbpc.programPeriodStart
                    AND bh.billingDate <= pbpc.programPeriodEnd
            GROUP BY st.userId) AS Semester,
        CONCAT(pgm.programName,
                '#',
                b.batchName,
                '#',
                seat.seatName) AS programIntakeSeatType,
        pgm.programCode AS ProgramCode,
        ou.code AS DebitNoteIAU,
        bh.dueDate AS DueDate,
        fh.feeHeadName AS FeeHeadName,
        bfprs.billableAmount AS Amount,
        bh.reasonForManualBill AS ReasonForManualBilling,
        fpt.feePlanType AS FeePlanType,
        fp.feePlanId AS FeePlanId,
        fpr.feeRuleDesc AS FeePlanRule,
        fsm.stageName AS FeePlanStage,
        bh.billStatus AS BillStatus,
        bh.lastUpdate AS LastUpdate
    FROM
        bill_fee_plan_rule_stage bfprs
            LEFT OUTER JOIN
        bill_header bh ON bfprs.billId = bh.id
            LEFT OUTER JOIN
        currency c ON c.id = bh.currencyId
            LEFT OUTER JOIN
        students st ON st.userId = bh.studentId
            LEFT OUTER JOIN
        sponsors sp ON sp.id = bh.sponsorId
            LEFT OUTER JOIN
        organization_units ou ON bh.iauId = ou.id
            LEFT OUTER JOIN
        application a ON a.id = bh.applicantId
            LEFT OUTER JOIN
        applicant_person ap ON ap.id = a.applicantPersonId
            LEFT OUTER JOIN
        users u ON u.id = bh.userId
            LEFT OUTER JOIN
        users st_user ON st_user.id = st.userId
            LEFT OUTER JOIN
        persons p ON p.id = st.personId
            LEFT OUTER JOIN
        billed_user_type but ON but.id = bh.raiseBillFor
            LEFT OUTER JOIN
        prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
            LEFT OUTER JOIN
        batches b ON b.id = pbsc.programBatchId
            LEFT OUTER JOIN
        programs pgm ON b.programId = pgm.id
            LEFT OUTER JOIN
        seat_types seat ON seat.id = pbsc.seatTypeId
            LEFT OUTER JOIN
        fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
            LEFT OUTER JOIN
        fee_heads fh ON fshc.feeHeadId = fh.id
            LEFT OUTER JOIN
        fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
            LEFT OUTER JOIN
        fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
            LEFT OUTER JOIN
        fee_plan fp ON fp.id = fpr.feePlanId
            LEFT OUTER JOIN
        fee_plan_type fpt ON fpt.id = fp.feePlanType
            LEFT OUTER JOIN
        fee_stage_master fsm ON fsm.id = fprs.stageId
    WHERE
        bh.raiseBillCategory = 'BILL_RECEIVABLE'
    GROUP BY bfprs.id;
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='credit_note_view_sapb1')) THEN 
CREATE VIEW credit_note_view_sapb1 AS
    SELECT 
        bfprs.id AS DebitNoteFeeHeadId,
        bh.billNo AS DebitNoteNo,
        bh.raiseBillType AS DebitNoteType,
        but.billedUserType AS DebitNoteFor,
        c.currencyCode AS DebitNoteCurrency,
        bh.billingDate AS DebitNoteDate,
        CASE
            WHEN bh.applicantId IS NOT NULL THEN CONCAT(a.code, '/', ap.printName)
            WHEN bh.studentId IS NOT NULL THEN CONCAT(st_user.code, '/', st_user.printName)
            WHEN bh.sponsorId IS NOT NULL THEN CONCAT(sp.sponsorshipCode, '/', sp.sponsorName)
            WHEN bh.userId IS NOT NULL THEN CONCAT(u.code, '/', u.printName)
            ELSE NULL
        END AS DebitNoteOwner,
        (SELECT 
                pbpc.programPeriodName
            FROM
                program_batch_students pbs
                    LEFT OUTER JOIN
                prog_batch_period_config pbpc ON pbs.progBatchPeriodConfigId = pbpc.id
                    LEFT OUTER JOIN
                admission adm ON adm.id = pbs.admissionId
                    LEFT OUTER JOIN
                students st ON st.userId = adm.studentId
            WHERE
                st.userId = bh.studentId
                    AND bh.billingDate >= pbpc.programPeriodStart
                    AND bh.billingDate <= pbpc.programPeriodEnd
            GROUP BY st.userId) AS Semester,
        CONCAT(pgm.programName,
                '#',
                b.batchName,
                '#',
                seat.seatName) AS programIntakeSeatType,
        pgm.programCode AS ProgramCode,
        ou.code AS DebitNoteIAU,
        bh.dueDate AS DueDate,
        fh.feeHeadName AS FeeHeadName,
        bfprs.billableAmount AS Amount,
        bh.reasonForManualBill AS ReasonForManualBilling,
        fpt.feePlanType AS FeePlanType,
        fp.feePlanId AS FeePlanId,
        fpr.feeRuleDesc AS FeePlanRule,
        fsm.stageName AS FeePlanStage,
        bh.billStatus AS BillStatus,
        bh.lastUpdate AS LastUpdate
    FROM
        bill_fee_plan_rule_stage bfprs
            LEFT OUTER JOIN
        bill_header bh ON bfprs.billId = bh.id
            LEFT OUTER JOIN
        currency c ON c.id = bh.currencyId
            LEFT OUTER JOIN
        students st ON st.userId = bh.studentId
            LEFT OUTER JOIN
        sponsors sp ON sp.id = bh.sponsorId
            LEFT OUTER JOIN
        organization_units ou ON bh.iauId = ou.id
            LEFT OUTER JOIN
        application a ON a.id = bh.applicantId
            LEFT OUTER JOIN
        applicant_person ap ON ap.id = a.applicantPersonId
            LEFT OUTER JOIN
        users u ON u.id = bh.userId
            LEFT OUTER JOIN
        users st_user ON st_user.id = st.userId
            LEFT OUTER JOIN
        persons p ON p.id = st.personId
            LEFT OUTER JOIN
        billed_user_type but ON but.id = bh.raiseBillFor
            LEFT OUTER JOIN
        prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
            LEFT OUTER JOIN
        batches b ON b.id = pbsc.programBatchId
            LEFT OUTER JOIN
        programs pgm ON b.programId = pgm.id
            LEFT OUTER JOIN
        seat_types seat ON seat.id = pbsc.seatTypeId
            LEFT OUTER JOIN
        fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
            LEFT OUTER JOIN
        fee_heads fh ON fshc.feeHeadId = fh.id
            LEFT OUTER JOIN
        fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
            LEFT OUTER JOIN
        fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
            LEFT OUTER JOIN
        fee_plan fp ON fp.id = fpr.feePlanId
            LEFT OUTER JOIN
        fee_plan_type fpt ON fpt.id = fp.feePlanType
            LEFT OUTER JOIN
        fee_stage_master fsm ON fsm.id = fprs.stageId
    WHERE
        bh.raiseBillCategory = 'BILL_PAYABLE'
    GROUP BY bfprs.id;
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='receipt_view_sapb1')) THEN 
CREATE VIEW receipt_view_sapb1 AS
    SELECT 
        rh.voucherMode AS VoucherType,
        rh.receiptType AS ReceiptMode,
        rh.receiptNo AS ReceiptNo,
        but.raiseBillType AS ReceiptType,
        but.billedUserType AS ReceiptFor,
        ou.code AS ReceivingIAU,
        c.currencyCode AS ReceivingCurrency,
        b.bankName AS OurBankAccount,
        rh.transactionDate AS ReceiptDate,
        CASE
            WHEN rh.applicantId IS NOT NULL THEN CONCAT(a.code, '/', ap.printName)
            WHEN rh.studentId IS NOT NULL THEN CONCAT(st_user.code, '/', st_user.printName)
            WHEN rh.sponsorId IS NOT NULL THEN CONCAT(sp.sponsorshipCode, '/', sp.sponsorName)
            WHEN rh.userId IS NOT NULL THEN CONCAT(u.code, '/', u.printName)
            ELSE NULL
        END AS ReceiptOwner,
        IFNULL(GROUP_CONCAT(fpm.paymentModeName), NULL) AS PaymentMode,
        IFNULL(GROUP_CONCAT(rpr.instrumentNo), NULL) AS InstrumentNo,
        IFNULL(GROUP_CONCAT(rpr.instrumentDate), NULL) AS InstrumentDate,
        rpr.amount AS Amount,
        rpr.bankChargesAmount AS BankChargesAmount,
        rpr.bankChargesPercentage AS BankChargesPercentage,
        bdom.bankName AS DrawnOnBank,
        rh.narration AS Narration
    FROM
        receipt_payment_instrument rpr
            LEFT OUTER JOIN
        receipt_header rh ON rpr.receiptHeaderId = rh.id
            LEFT OUTER JOIN
        users u ON rh.userId = u.id
            LEFT OUTER JOIN
        sponsors sp ON rh.sponsorId = sp.id
            LEFT OUTER JOIN
        application a ON rh.applicantId = a.id
            LEFT OUTER JOIN
        applicant_person ap ON a.applicantPersonId = ap.id
            LEFT OUTER JOIN
        students st ON st.userId = rh.studentId
            LEFT OUTER JOIN
        users st_user ON rh.studentId = st_user.id
            LEFT OUTER JOIN
        persons p ON p.id = st.personId
            LEFT OUTER JOIN
        billed_user_type but ON but.id = rh.receiptFor
            LEFT OUTER JOIN
        organization_units ou ON rh.iauId = ou.id
            LEFT OUTER JOIN
        currency c ON c.id = rh.currencyId
            LEFT OUTER JOIN
        bank b ON b.id = rh.depositedBank
            LEFT OUTER JOIN
        fee_payment_modes fpm ON fpm.id = rpr.paymentMode
            LEFT OUTER JOIN
        bank_drawn_on_master bdom ON bdom.id = rpr.instrumentBank
            LEFT OUTER JOIN
        bank_charges_history bch ON rpr.bankChargesHistoryId = bch.id
    WHERE
        rpr.receiptHeaderId IS NOT NULL
    GROUP BY rpr.id;
END IF; 

END $$
CALL V20201027162629__Create_FeeAndPaymentViewsForSAPB1 () $$ 
DROP PROCEDURE IF EXISTS V20201027162629__Create_FeeAndPaymentViewsForSAPB1 $$ 
DELIMITER ;