DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_subjectdetails //
CREATE  PROCEDURE sp_tvet_subjectdetails()
BEGIN

select distinct cou.courseCode as Subject_Code,
  cou.courseName as Subject_Name,   cnl.itemCode as NQF_Level_Id,
  cec.courseCESMId as Subfield_Id,   rt.itemCode as AET_Level_Id,
  DATE_FORMAT(per.programPeriodStart, '%Y%m%d') as Subject_Reg_Start_Date,
  DATE_FORMAT(per.programPeriodEnd, '%Y%m%d') as Subject_Reg_End_Date,
  al.locationCode as Provider_Code,
  '541' as Provider_ETQE_Id,
  CASE WHEN cou.whetherDeleted =0 then 1 ELSE 2 end as Subject_Status_Id ,
  cou.courseCredits as Subject_Credit,
  DATE_FORMAT(NOW(), '%Y%m%d') as Date_Stamp
 from   
   program_courses pc 
 left join
 batches b  on pc.programBatchId = b.id 
 left join
programs p on b.programId = p.id
      left join
  academy_location al on al.id = p.academyLocationId        
  left join registration_type rt on rt.id = p.registrationTypeId        
  left join affiliated_university au on au.id = p.affiliatedUniversityId        
 left join prog_batch_period_config per on  per.programBatchId = b.id
 left join courses cou on cou.id = pc.courseId
    left join course_cesm_code cec on cec.id = cou.courseCESMCodeId 
    left join course_nqf_level cnl on cnl.id = cou.courseNQFLevelId   
    where
  year(now()) between year(b.startDate) and year(b.tillDate);
END//
DELIMITER ;