DELIMITER //

DROP PROCEDURE IF EXISTS sp_tvet_staffdetails //
CREATE  PROCEDURE sp_tvet_staffdetails()
BEGIN


select usr.code as "Employee Id",
per.firstName as "First Name",
per.middleName as "Middle Name",
per.lastName as "Last Name",
per.nationalID as National_Id,
iddetail.idNumber as Person_Alternate_Id,
iddetail.itemCode as Alternate_Id_Type_Id,
desg.itemCode as Staff_Type_Id,
per.externalSysRefOne as Staff_Number,
'' as Filler01,
DATE_FORMAT(staf.joiningDate, '%Y%m%d') as Appointment_Date,
DATE_FORMAT(staf.exitDate, '%Y%m%d')  as Termination_Date,
case when usr.status=1 then 1   when usr.status=0  then 2 else null end Employment_Status_Id,
per.externalSysRefOne as Persal_Number,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
staf.facultyType as Appointment_Nature_Id,
staf.employeeType as Appointment_Type_Id,
per.externalSysRefOne as Remuneration_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp

from staffs staf  join persons per on(staf.personid=per.id)
left join 
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
 left join designations desg on(staf.designationId=desg.id)
 left join users usr on(usr.id=staf.userid)
left join user_academy_locations alpur on(usr.id=alpur.userid)
left join academy_location al on(alpur.academyLocationId=al.id)
left join locations loc on(al.locationId=loc.id)
group by staf.userid;

END//
DELIMITER ;