DELIMITER $$
DROP PROCEDURE IF EXISTS V20201105173905__Create_update_campaign_details_view $$
CREATE PROCEDURE V20201105173905__Create_update_campaign_details_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'campaign_details_view')) THEN 
DROP view `campaign_details_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'campaign_details_view')) THEN 
create or replace view campaign_details_view as
select campacad.academyLocationId,al.academyName,al.academyCode,al.locationName,al.locationCode,
al.displayName as academy_location_name,
ir.itemvalue as intake_year ,modeofDelivery,registrationType,
campaignType,presentationType as presentation_medium_type,
presentationSubType as Presentation_Sub_Type,campaignName
,campnew.status,usr.printName as Owner,createdOn,startDate , enddate as Till_Date,
numberOfleadsTargeted ,count(enq.id) as Number_of_Leads_Captured,
campsc.itemvalue as School,cspm.schoolPriority
from campaign_new campnew left join users usr
on(campnew.ownerId=usr.id)
left join intake_year ir on(ir.id=campnew.intakeYearId)
left join campaign_academy_location campacad on(campacad.campaignNewId=campnew.id)
left join academy_location al on(al.id=campacad.academyLocationId)
left join enquiry enq on(enq.campaignNewId=campnew.id)
left join campaign_school_mapping campscmp on(campscmp.campaignNewId=campnew.id)
left join campaign_school campsc on(campsc.id=campscmp.campaignSchoolId)
left join campaign_school_priority_mapping cspm on(cspm.campaignSchoolId = campsc.id)
group by campnew.id,campsc.id;
END IF; 

END $$
CALL V20201105173905__Create_update_campaign_details_view () $$ 
DROP PROCEDURE IF EXISTS V20201105173905__Create_update_campaign_details_view $$ 
DELIMITER ;