DELIMITER $$
DROP PROCEDURE IF EXISTS V20201106121943__Create_disciplinaryActionsSU $$
CREATE PROCEDURE V20201106121943__Create_disciplinaryActionsSU()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='disciplinary_actions_su')) THEN 
CREATE TABLE `disciplinary_actions_su` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `personId` bigint DEFAULT NULL,
  `misConductTypeId` bigint DEFAULT NULL,
  `dateOfMisconduct` datetime DEFAULT NULL,
  `isTempSuspension` bit(1) DEFAULT NULL,
  `tempSuspensionDate` datetime DEFAULT NULL,
  `committeeId` bigint DEFAULT NULL,
  `tempRestrictionId` bigint DEFAULT NULL,
  `isTempSuspensionLapse` bit(1) DEFAULT NULL,
  `tempSuspensionLapseDate` datetime DEFAULT NULL,
  `whetherAppealed` bit(1) DEFAULT NULL,
  `whetherDeleted` bit(1) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_discip_SU_person_idx` (`personId`),
  KEY `FK_discip_SU_miscconduct_idx` (`misConductTypeId`),
  KEY `FK_discip_SU_committee_idx` (`committeeId`),
  KEY `FK_discip_SU_temp_sus_idx` (`tempRestrictionId`),
  KEY `FK_discip_SU_temp_lastUpdated_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_discip_SU_committee` FOREIGN KEY (`committeeId`) REFERENCES `committee` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK_discip_SU_miscconduct` FOREIGN KEY (`misConductTypeId`) REFERENCES `misconduct_type` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK_discip_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK_discip_SU_temp_lastUpdated` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK_discip_SU_temp_sus` FOREIGN KEY (`tempRestrictionId`) REFERENCES `temp_suspen_access_restriction` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ;
END IF; 

END $$
CALL V20201106121943__Create_disciplinaryActionsSU () $$ 
DROP PROCEDURE IF EXISTS V20201106121943__Create_disciplinaryActionsSU $$ 
DELIMITER ;