DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_staffsubjectdetails //
DELIMITER //
CREATE  PROCEDURE sp_tvet_staffsubjectdetails()
BEGIN

select distinct per.externalSysRefOne as Staff_Number,'' as Unit_Standard_Id,
course.courseCode as Subject_Code  
,workex.Year_Teaching_Experience
,pertraining.Years_Formal_Training,
loc.shortCode as Provider_Code ,
541 as Provider_ETQE_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
from prog_batch_course_faculty progbcf
join program_batch_course_param  progbcp on(progbcf.progBatchCourseParamId=progbcp.id)
join course_variants cv on(progbcp.courseVarientId=cv.id)
join courses course on(cv.courseId=course.id)
join staffs staf on(progbcf.facultyId=staf.userId)
join persons per on(per.id=staf.personid)
left join (select per.id,
ROUND(sum(TIMESTAMPDIFF(month, joiningDate, exitDate))/12) as Year_Teaching_Experience
from persons per join work_experience we on(per.id=we.personid) group by per.id) workex
on(per.id=workex.id)
left join (select per.id,
ROUND(sum(TIMESTAMPDIFF(month, fromDate, toDate))/12) as Years_Formal_Training
from persons per join person_training_details we on(per.id=we.personid)
join training_type trt on (trt.id=we.trainingTypeId and trt.itemValue='Subject Training')
group by per.id) pertraining
on(pertraining.id=per.id)
join users usr on(usr.id=staf.userId)
join user_academy_locations usral on(usral.userid=usr.id)
join academy_location al on(al.id=usral.academyLocationId)
join locations loc on(loc.id=al.locationId);
END//
DELIMITER ;
DELIMITER ;