DELIMITER $$
DROP PROCEDURE IF EXISTS V20201119191030__Create_sales_presentaion_target_view $$
CREATE PROCEDURE V20201119191030__Create_sales_presentaion_target_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_presentaion_target_view')) THEN 
DROP view `sales_presentaion_target_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_presentaion_target_view')) THEN 
CREATE OR REPLACE view sales_presentaion_target_view as select managetarget.academyLocationId,managetarget.academyName,managetarget.academyCode,
managetarget.locationName,managetarget.locationCode,
managetarget.intake_year,managetarget.Target_For,sum(managetarget.Total_Target) as Total_Presentation_Target,
usr.printname as Staff_Owner_Name,sum(enqdata.cnt) AS total_actual_leads

from (
select al.id as academyLocationId,al.academyName,al.academyCode,al.locationName,locationCode
,irr.itemValue as intake_year, manageTargetType as Target_For,
manage.actualTarget as Total_Target,staffId,manage.intakeYearId
from academy_location al
left join manage_target_tertiary manage on(manage.academyLocationId=al.id and manageTargetType='PRESENTATIONS')
left join intake_year ir on(manage.intakeYearId=ir.id)
left join programs prog on(prog.academyLocationId=al.id)
left join batches btc on(btc.programid=prog.id)
join intake_year irr on(btc.intakeYearId=irr.id)
group by academyName,locationCode,manageTargetType,staffId
) managetarget left join

(select  count( distinct campnew.id) cnt,
campnew.ownerId, campal.academyLocationId,campnew.intakeYearId
from campaign_new campnew
join campaign_academy_location campal on(campnew.id=campal.campaignNewId)
group by campnew.ownerId, campal.academyLocationId,campnew.intakeYearId) enqdata

on(managetarget.intakeYearId= enqdata.intakeYearId and
managetarget.academyLocationId=enqdata.academyLocationId
and managetarget.staffId=enqdata.ownerId)
left join users usr on(managetarget.staffId=usr.id)
group by managetarget.academyName,managetarget.locationCode,managetarget.Target_For,usr.id;
END IF; 

END $$
CALL V20201119191030__Create_sales_presentaion_target_view () $$ 
DROP PROCEDURE IF EXISTS V20201119191030__Create_sales_presentaion_target_view $$ 
DELIMITER ;