DELIMITER $$
DROP PROCEDURE IF EXISTS V20201207164051__Create_CreditFeeMapping $$
CREATE PROCEDURE V20201207164051__Create_CreditFeeMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='credit_fee_mapping')) THEN 
CREATE TABLE `credit_fee_mapping` (
  `id` BIGINT NOT NULL,
  `programId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL,
  `seatTypeId` BIGINT NOT NULL,
  `amountPerCredit` DOUBLE(20,2) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_credit_fee_mapping_to_programs_idx` (`programId` ASC) INVISIBLE,
  INDEX `fk_credit_fee_mapping_to_batches_idx` (`batchId` ASC) INVISIBLE,
  INDEX `fk_credit_fee_mapping_to_periods_idx` (`periodId` ASC) INVISIBLE,
  INDEX `fk_credit_fee_mapping_to_seatTypes_idx` (`seatTypeId` ASC) INVISIBLE,
  CONSTRAINT `fk_credit_fee_mapping_to_programs`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_credit_fee_mapping_to_batches`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_credit_fee_mapping_to_periods`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_credit_fee_mapping_to_seatTypes`
    FOREIGN KEY (`seatTypeId`)
    REFERENCES `seat_types` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20201207164051__Create_CreditFeeMapping () $$ 
DROP PROCEDURE IF EXISTS V20201207164051__Create_CreditFeeMapping $$ 
DELIMITER ;