DELIMITER $$
DROP PROCEDURE IF EXISTS V20210105185638__Create_thesis_mgt_document $$
CREATE PROCEDURE V20210105185638__Create_thesis_mgt_document()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='thesis_management_document')) THEN 
    CREATE TABLE `thesis_management_document` (
  `id` BIGINT(20)  NOT NULL AUTO_INCREMENT,
  `thesisManagementId` BIGINT(20) NOT NULL,
  `documentType` VARCHAR(45) DEFAULT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `status` VARCHAR(100) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_thesis_mgt_doc_id_idx` (`thesisManagementId` ASC),
  INDEX `fk_thesis_mgt_document_ref_id_idx` (`documentId` ASC),
  INDEX `fk_thesis_mgt_doc_user_ref_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_thesis_mgt_doc_id`
    FOREIGN KEY (`thesisManagementId`)
    REFERENCES `thesis_management` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_thesis_mgt_document_ref_id`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_thesis_mgt_doc_user_ref_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
     ON UPDATE NO ACTION)ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20210105185638__Create_thesis_mgt_document () $$ 
DROP PROCEDURE IF EXISTS V20210105185638__Create_thesis_mgt_document $$ 
DELIMITER ;