DELIMITER $$
DROP PROCEDURE IF EXISTS V20210223154639__Create_TransportVehiclePermit $$
CREATE PROCEDURE V20210223154639__Create_TransportVehiclePermit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='trans_vehicle_permit')) THEN 
CREATE TABLE `trans_vehicle_permit` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `vehicleId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) DEFAULT NULL,
  `expirationDate` DATE NULL,
  `issueDate` DATE NULL,
  `issuedBy` VARCHAR(255) NULL,
  `permitNumber` VARCHAR(255) NULL,
 `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `trans_vp_vehicle_idx` (`vehicleId` ASC),
  INDEX `fk_vp_users_idx` (`lastUpdatedBy` ASC),
  INDEX `trans_vp_document_x` (`documentId` DESC),
  CONSTRAINT `trans_vp_vehicle_id`
    FOREIGN KEY (`vehicleId`)
    REFERENCES `trans_vehicle` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
CONSTRAINT `trans_vp_document_idx`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_vp_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210223154639__Create_TransportVehiclePermit () $$ 
DROP PROCEDURE IF EXISTS V20210223154639__Create_TransportVehiclePermit $$ 
DELIMITER ;