DELIMITER $$
DROP PROCEDURE IF EXISTS V20210302184352__Insert_CourseTopicsSessionWiseReport $$
CREATE PROCEDURE V20210302184352__Insert_CourseTopicsSessionWiseReport()
BEGIN


IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'COURSE_TOPIC_REPORT' )) THEN 
set @topic = (select id from report_type WHERE typeName = 'Planning Reports');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@topic, 'COURSE_TOPIC_REPORT', 'Course Topic Report', 'COURSE_TOPIC_REPORT.png', 'COURSE_TOPIC_REPORT_CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'COURSE_TOPIC_REPORT.jasper', 'AcademiaLogo.png'); 
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'COURSE_TOPIC_REPORT')) THEN 
set @course = (select max(id) from `report_template` WHERE templateCode = 'COURSE_TOPIC_REPORT');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_TEACHING_PLAN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_TEACHING_PLAN', 'Course wise TeachingPlan for Session :', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_COURSE', 'Course :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_FACULTY_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_FACULTY_NAME', 'Faculty :', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_SERIAL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_SERIAL_NUM', 'Sr.No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_TOPIC_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_TOPIC_CODE', 'Topic Code', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_TOPIC_COVERED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_TOPIC_COVERED', 'Topic Covered', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_DATE', 'Date', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_SECTION', 'Section', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_PAGE_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_PAGE_NUM', 'Page No.', '1', now());

END IF;
 

END $$
CALL V20210302184352__Insert_CourseTopicsSessionWiseReport() $$
DROP PROCEDURE IF EXISTS V20210302184352__Insert_CourseTopicsSessionWiseReport $$
DELIMITER ;
