DELIMITER $$
DROP PROCEDURE IF EXISTS V20210309160320__Alter_AssLevelReqIntoExamBoard $$
CREATE PROCEDURE V20210309160320__Alter_AssLevelReqIntoExamBoard()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='exam_board_master' AND column_name='assessmentLevelRequired')) THEN 
ALTER TABLE `exam_board_master` 
ADD COLUMN `assessmentLevelRequired` BIT(1) DEFAULT 0 AFTER `markingType`;
END IF; 

SET @standardMasterId=(SELECT MAX(id) FROM standard_master where tableName='exam_board_master' AND masterName='EXAM_BOARD_MASTER');

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'assessmentLevelRequired' AND standardMasterId = @standardMasterId)) THEN 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId + 1, 'assessmentLevelRequired', 'ASSESSMENT_LEVEL_REQUIRED', @standardMasterId, 'Boolean', '6', false, 0, 0, 1, '1', SYSDATE());
END IF; 

SET SQL_SAFE_UPDATES = 0;
IF EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'itemValueInOtherLanguage' AND standardMasterId = @standardMasterId)) THEN 
UPDATE standard_master_items SET `diaplayOrder` = '3' WHERE dbFieldName = 'itemValueInOtherLanguage' AND standardMasterId = @standardMasterId;
END IF;

IF EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'equivalentExamBoardId' AND standardMasterId = @standardMasterId)) THEN 
UPDATE standard_master_items SET `diaplayOrder` = '4' WHERE dbFieldName = 'equivalentExamBoardId' AND standardMasterId = @standardMasterId;
END IF;

IF EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'markingType' AND standardMasterId = @standardMasterId)) THEN 
UPDATE standard_master_items SET `diaplayOrder` = '5' WHERE dbFieldName = 'markingType' AND standardMasterId = @standardMasterId;
END IF;
SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20210309160320__Alter_AssLevelReqIntoExamBoard() $$
DROP PROCEDURE IF EXISTS V20210309160320__Alter_AssLevelReqIntoExamBoard $$
DELIMITER ;