DELIMITER $$

DROP PROCEDURE IF EXISTS V20210315141950__AlterApplicantHostelDetail $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210315141950__AlterApplicantHostelDetail()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_hostel_details' 
  AND column_name='academyLocationId')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `applicant_hostel_details` 
	ADD COLUMN `academyLocationId` BIGINT(20) NULL DEFAULT NULL AFTER `applicantHostelRequirementId`,
	ADD INDEX `fk_applicant_hostel_details_al_idx` (`academyLocationId` ASC);
	ALTER TABLE `applicant_hostel_details` 
	ADD CONSTRAINT `fk_applicant_hostel_details_al`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V20210315141950__AlterApplicantHostelDetail $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210315141950__AlterApplicantHostelDetail $$
 
DELIMITER ;