DELIMITER $$
DROP PROCEDURE IF EXISTS V20210325123830__Create_ManageSubHolCatAuthorizationBasis $$
CREATE PROCEDURE V20210325123830__Create_ManageSubHolCatAuthorizationBasis()
BEGIN

IF NOT EXISTS ((   SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='sub_hold_cat_athorization_basis')) THEN 
   CREATE TABLE `sub_hold_cat_athorization_basis` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `subHoldCatId` BIGINT(20) NOT NULL,
  `staffId` BIGINT(20) NULL,
  `roleId` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_sub_hold_cat_athorization_basis_subHoldCat_idx` (`subHoldCatId` ASC),
  INDEX `fk_sub_hold_cat_athorization_basis_staff_id_idx` (`staffId` ASC),
  INDEX `fk_sub_hold_cat_athorization_basis_role_id_idx` (`roleId` ASC),
  INDEX `fk_sub_hold_cat_athorization_basis_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_sub_hold_cat_athorization_basis_subHoldCat_id`
    FOREIGN KEY (`subHoldCatId`)
    REFERENCES `manage_sub_hold_category` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_sub_hold_cat_athorization_basis_staff_id`
    FOREIGN KEY (`staffId`)
    REFERENCES `staffs` (`userId`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
 CONSTRAINT `fk_sub_hold_cat_athorization_basis_role_id`
    FOREIGN KEY (`roleId`)
    REFERENCES `roles` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sub_hold_cat_athorization_basis_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210325123830__Create_ManageSubHolCatAuthorizationBasis () $$ 
DROP PROCEDURE IF EXISTS V20210325123830__Create_ManageSubHolCatAuthorizationBasis $$ 
DELIMITER ;