DELIMITER $$
DROP PROCEDURE IF EXISTS V20210503173009__Create_autoLogoutTime $$
CREATE PROCEDURE V20210503173009__Create_autoLogoutTime()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='auto_log_out_time')) THEN 
CREATE TABLE `auto_log_out_time` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `hours` bigint DEFAULT NULL,
  `minutes` bigint DEFAULT NULL,
  `totalInMillis` bigint DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_auto_logout_last_updated_by_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_auto_logout_last_updated_by` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20210503173009__Create_autoLogoutTime () $$ 
DROP PROCEDURE IF EXISTS V20210503173009__Create_autoLogoutTime $$ 
DELIMITER ;