DELIMITER $$
DROP PROCEDURE IF EXISTS V20210512120740__Create_examConcessionBmapping $$
CREATE PROCEDURE V20210512120740__Create_examConcessionBmapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_concession_batch_mapping' )) THEN 
CREATE TABLE `exam_concession_batch_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `examConcessionId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `academyLocationId` BIGINT NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `examConcessionBatchMapping_lastUpdatedby` (`lastUpdatedBy` ASC) ,
  INDEX `examConcessionBatchMapping_examConcessionId` (`examConcessionId` ASC) ,
  INDEX `exam_concession_bm_batchId_idx` (`batchId` ASC) ,
  INDEX `exam_concession_bm__academyLocationId_idx` (`academyLocationId` ASC) ,
  CONSTRAINT `exam_concession_bm_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_concession_bm_examcancellationId`
	FOREIGN KEY (`examConcessionId`)
	REFERENCES `exam_concession` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_concession_bm_batchId`
	FOREIGN KEY (`batchId`)
	REFERENCES `batches` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_concession_bm_academyLocationId`
	FOREIGN KEY (`academyLocationId`)
	REFERENCES `academy_location` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210512120740__Create_examConcessionBmapping () $$ 
DROP PROCEDURE IF EXISTS V20210512120740__Create_examConcessionBmapping $$ 
DELIMITER ;