DELIMITER $$
DROP PROCEDURE IF EXISTS V20210607191216__Create_EC_ServiceRequest_Form $$
CREATE PROCEDURE V20210607191216__Create_EC_ServiceRequest_Form()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_concession_details')) THEN 
CREATE TABLE `exam_concession_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `version` BIGINT(20),
  `documentId` BIGINT(20),
  `admissionId` BIGINT(20) NOT NULL,
  `periodId` BIGINT(20) NOT NULL,
  `serviceRequestId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_exam_concession_details_documentId_idx` (`documentId` ASC),
  INDEX `fk_exam_concession_details_admissionId_idx` (`admissionId` ASC),
  INDEX `fk_exam_concession_details_periodId_idx` (`periodId` ASC),
  INDEX `fk_exam_concession_details_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_exam_concession_details_documentId_idx`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_exam_concession_details_admissionId_idx`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_exam_concession_details_lastUpdatedBy_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_exam_concession_details_periodId_idx`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210607191216__Create_EC_ServiceRequest_Form () $$ 
DROP PROCEDURE IF EXISTS V20210607191216__Create_EC_ServiceRequest_Form $$ 
DELIMITER ;