DELIMITER $$
DROP PROCEDURE IF EXISTS V20210611114729__Update_StudentAdmissionProgramDataProvider $$
CREATE PROCEDURE V20210611114729__Update_StudentAdmissionProgramDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dydt_data_provider WHERE `providerName`='Student Admission Program Data Provider')) THEN 

SET @dataproviderId2=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Admission Program Data Provider');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
    p.programCode AS program_code,
    p.programName AS program_name,
    p.programNameToBePrint AS program_print_name,
    pd.shortCode AS primary_dept_code,
    pd.deptName AS primary_dept_name,
    psd.shortCode AS secondary_dept_code,
    psd.deptName AS secondary_dept_name,
    b.batchName AS batch_name,
    b.printName AS batch_printName,
    sal.salutationName AS student_salutation,
    DATE_FORMAT(DATE(b.startDate), "%d-%m-%Y") AS batch_start_date,
    DATE_FORMAT(DATE(b.tillDate), "%d-%m-%Y") AS batch_tilldate,
    ay.itemValue AS intake_year,
    a.code AS admission_code,
    a.studentId AS student_id,
    pbpc.programPeriodName AS period_name,
    pbpc.printName AS period_print_name,
    prsn.photoUrl AS img_photo_url,
    DATE_FORMAT(DATE(NOW()), "%d-%m-%Y") AS today_date,
    u.code AS person_code,
    prsn.firstName AS first_name,
    prsn.middleName AS middle_name,
    prsn.lastName AS last_name,
    CONCAT(UCASE(LEFT(gender, 1)),
            LCASE(SUBSTRING(gender, 2))) AS student_gender,
    cc.itemValue AS cast_category,
    DATE_FORMAT(DATE(prsn.birthDate), "%d-%m-%Y") AS birth_date,
    ntn.itemValue AS nationality,
    rel.itemValue AS religions,
    sec.sectionCode AS section_code,
    DATE_FORMAT(a.admissionDate, "%d-%m-%Y") AS admission_date,
    TRUNCATE(DATEDIFF(DATE_FORMAT(DATE(NOW()), "%Y-%m-%d"),
                prsn.birthDate) / 365.25,
        0) AS student_age,
    (CASE
        WHEN (prsn.bloodGroup = "O_PLUS") THEN "O+"
        WHEN (prsn.bloodGroup = "O_MINUS") THEN "O-"
        WHEN (prsn.bloodGroup = "A_PLUS") THEN "A+"
        WHEN (prsn.bloodGroup = "A_MINUS") THEN "A-"
        WHEN (prsn.bloodGroup = "B_PLUS") THEN "B+"
        WHEN (prsn.bloodGroup = "B_MINUS") THEN "B-"
        WHEN (prsn.bloodGroup = "AB_PLUS") THEN "AB+"
        WHEN (prsn.bloodGroup = "AB_MINUS") THEN "AB-"
        ELSE NULL
    END) AS blood_group,
    affUniv.itemValue AS affiliated_University,
    affUniv.itemValueOtherLanguage AS affiliated_University_other_language,
    prsn.birth_place AS birth_place,
    prsn.birth_place_language AS birth_place_other_language,
    prsn.printNameOtherLanguage AS print_Name_Other_Language,
    p.programNameLanguageOne AS program_Name_Language_One,
    md.itemValue AS mode_of_delievery,
    md.itemValueOtherLanguage AS mode_of_delievery_other_language,
    dcr.recommendation AS recommendation,
    pg.groupName AS program_group,
    co.effectiveDate AS effective_pass_out_date,
    po.decisionNumber AS  decision_number
FROM
    program_batch_students pbs
        LEFT JOIN
    admission a ON a.id = pbs.admissionId
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON b.programId = p.id
        LEFT JOIN
    intake_year ay ON ay.id = b.intakeYearId
        LEFT JOIN
    department pd ON pd.id = p.programDepartmentId
        LEFT JOIN
    department psd ON psd.id = p.subDepartmentId
        LEFT JOIN
    prog_batch_period_config pbpc ON pbpc.programBatchId = b.id
        LEFT JOIN
    students st ON st.userId = a.studentId
        LEFT JOIN
    persons prsn ON prsn.id = st.personId
        LEFT JOIN
    users u ON u.id = st.userId
        LEFT JOIN
    caste_categories cc ON cc.id = prsn.castCategoryId
        LEFT JOIN
    nationalities ntn ON ntn.id = prsn.nationalityId
        LEFT JOIN
    religions rel ON rel.id = prsn.religionId
        LEFT JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    salutations sal ON sal.id = prsn.salutationId
        LEFT JOIN
    affiliated_university affUniv ON affUniv.id = p.affiliatedUniversityId
        LEFT JOIN
    mode_of_delivery md ON md.id = p.modeOfDeliveryId
        LEFT JOIN
    degree_classification_batch_mapping dcbm ON dcbm.batchId = b.id
        LEFT JOIN
    degree_classification_remark dcr ON dcr.degreeClassificationId = dcbm.degreeClassificationId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId 
    LEFT JOIN 
     completions co on co.admissionId= a.id and co.batchId=pbs.programBatchId
     Left JOIN
     passing_outs po on po.completionId=co.id',
    
    `resultColumnsDef` = 'program_code,program_name,program_print_name,batch_printName,student_salutation, primary_dept_code,cast_category,birth_date,
primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,intake_year,section_code,
admission_code,student_id,last_name,first_name,middle_name,person_code,img_photo_url,period_name,period_print_name,nationality,religions,
today_date,student_age,student_gender,blood_group,admission_date,affiliated_University,affiliated_University_other_language,birth_place,
birth_place_other_language,print_Name_Other_Language,program_Name_Language_One,mode_of_delievery,mode_of_delievery_other_language,recommendation,program_group,effective_pass_out_date,decision_number',
    `sqlWhereQueryDef` = 'WHERE a.id = PRM_ADMISSION_ID AND pbs.isCurrentPeriod = true AND pbs.isCurrentSection = true AND pbs.exitDate is null'
WHERE
    `dataSourceCode` = 'STUDENT_ADMISSION_PROGRAM_INFO' AND dataProviderId = @dataproviderId2;

SET @dydtdatalinitemId=(SELECT id FROM `dydt_data_line_item` where dataSourceCode='STUDENT_ADMISSION_PROGRAM_INFO');
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('effective_pass_out_date', 'Effective Passout Date',@dydtdatalinitemId),
    ('decision_number', 'Decision Number',@dydtdatalinitemId);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20210611114729__Update_StudentAdmissionProgramDataProvider () $$
DROP PROCEDURE IF EXISTS V20210611114729__Update_StudentAdmissionProgramDataProvider $$
DELIMITER ;