DELIMITER $$
DROP PROCEDURE IF EXISTS V20210702151625__CreateNSFASProvisionalFundStudDetail $$
CREATE PROCEDURE V20210702151625__CreateNSFASProvisionalFundStudDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='nsfas_provisional_fund_student_detail')) THEN 
CREATE TABLE `nsfas_provisional_fund_student_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `given_name` varchar(100) DEFAULT NULL,
  `sur_name` varchar(100) DEFAULT NULL,
  `nsfas_person_provisional_fund_id` bigint DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_nsfas_provisional_fund_student_detail_id_idx` (`lastUpdatedBy`),
  KEY `fk_nsfas_student_detail_provisional_fund_id_idx` (`nsfas_person_provisional_fund_id`),
  CONSTRAINT `fk_nsfas_student_detail_provisional_fund_id` FOREIGN KEY (`nsfas_person_provisional_fund_id`) REFERENCES `nsfas_person_provisional_fund` (`id`),
  CONSTRAINT `fk_nsfas_provisional_fund_student_detail_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
  ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20210702151625__CreateNSFASProvisionalFundStudDetail () $$ 
DROP PROCEDURE IF EXISTS V20210702151625__CreateNSFASProvisionalFundStudDetail $$ 
DELIMITER ;