DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708165956__Create_Socioeconomicinfo_view $$
CREATE PROCEDURE V20210708165956__Create_Socioeconomicinfo_view()
BEGIN
DROP VIEW IF EXISTS socioeconomicinfo_view;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='socioeconomicinfo_view')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `socioeconomicinfo_view` AS
    SELECT DISTINCT
        `appl`.`code` AS `code`,
        `ap`.`externalSysRefOne` AS `sunumber`,
        `ei`.`received_child_benefit` AS `childAllowance`,
        `ei`.`social_pension` AS `statePension`,
        `dd3`.`value` AS `schoolFeesBursary`,
        `dd4`.`value` AS `parentIncomGroup`,
        `dd5`.`value` AS `FinancialSupport`,
        `dd`.`value` AS `primaryGuardianQualification`,
        `dd2`.`value` AS `secondaryGuardianQualification`,
        `ir`.`itemValue` AS `applicationYear`
    FROM
        (((((((((((`applicant_person` `ap`
        LEFT JOIN `economic_information` `ei` ON ((`ei`.`applicant_person_id` = `ap`.`id`)))
        LEFT JOIN `application` `appl` ON ((`appl`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `drop_down` `dd` ON ((`dd`.`id` = `ei`.`parent_qualification1`)))
        LEFT JOIN `drop_down` `dd2` ON ((`dd2`.`id` = `ei`.`parent_qualification2`)))
        LEFT JOIN `drop_down` `dd3` ON ((`dd3`.`id` = `ei`.`is_scholarship`)))
        LEFT JOIN `drop_down` `dd4` ON ((`dd4`.`id` = `ei`.`parent_annual_income`)))
        LEFT JOIN `drop_down` `dd5` ON ((`dd5`.`id` = `ei`.`pay_study`)))
        JOIN `application_program` `apro` ON ((`apro`.`applicationId` = `appl`.`id`)))
        JOIN `programs` `prog` ON ((`apro`.`programId` = `prog`.`id`)))
        JOIN `batches` `btc` ON ((`btc`.`programId` = `prog`.`id`)))
        JOIN `intake_year` `ir` ON ((`btc`.`intakeYearId` = `ir`.`id`)))
    GROUP BY `ap`.`id`;

END IF; 

END $$
CALL V20210708165956__Create_Socioeconomicinfo_view () $$ 
DROP PROCEDURE IF EXISTS V20210708165956__Create_Socioeconomicinfo_view $$ 
DELIMITER ;