DELIMITER $$
DROP PROCEDURE IF EXISTS V20210803181328__Insert_KRMUEmployeeIdCard $$
CREATE PROCEDURE V20210803181328__Insert_KRMUEmployeeIdCard()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'KRMU_EMPLOYEE_ID_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '13', 'KRMU_EMPLOYEE_ID_CARD', 'KRMU-Employee Id Card', 'id_card_front.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'EMPLOYEE_ID_CARD_KRMU.jasper', 'AcademiaLogo.png');
END IF; 

set @KRMU_EMPLOYEE_ID_CARD = (select max(id) from report_template where templateCode ='KRMU_EMPLOYEE_ID_CARD');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='IDENTITY_CARD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'IDENTITY_CARD', 'IDENTITY CARD', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='EMERGENCY_CALL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'EMERGENCY_CALL', 'In Case of Emergency Please call :', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='DESIGNATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'DESIGNATION', 'Designation', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='DOB')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'DOB', 'D.O.B', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='ADDRESS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'ADDRESS', 'Address', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'NAME', 'Name', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='MOBILE_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'MOBILE_NO', 'Mobile No', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='CONTACT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'CONTACT_NO', 'Contact No', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='INSTRUCTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'INSTRUCTION', 'Instructions', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='INSTRUCTION_TEXT_LINE_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'INSTRUCTION_TEXT_LINE_ONE', 'First Instruction Text', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='INSTRUCTION_TEXT_LINE_4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'INSTRUCTION_TEXT_LINE_4', 'Fourth Instruction Text', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='INSTRUCTION_TEXT_LINE_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'INSTRUCTION_TEXT_LINE_TWO', 'Second Instruction Text', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='INSTRUCTION_TEXT_LINE_THREE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'INSTRUCTION_TEXT_LINE_THREE', 'Third Instruction Text', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='UNIVERSITY_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'UNIVERSITY_NAME', 'University name', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='ADDRESS_TEXT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'ADDRESS_TEXT', 'Address Value', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='EMAIL_TEXT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'EMAIL_TEXT', 'Email', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='WEBSITE_TEXT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'WEBSITE_TEXT', 'Website', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='PHONE_NUMBER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'PHONE_NUMBER', 'Ph. No.', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='TRANS_EMAIL_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'TRANS_EMAIL_ID', 'Email ID', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='TRANS_WEBSITE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'TRANS_WEBSITE_NAME', 'Website Name', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='TRANS_PHONE_NO_VALUE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'TRANS_PHONE_NO_VALUE', 'Phone Number' ,'1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @KRMU_EMPLOYEE_ID_CARD and keyValue='REGISTRAR_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@KRMU_EMPLOYEE_ID_CARD, 'REGISTRAR_SIGNATURE', 'Registrar Signature', '1', NOW());
END IF;

END $$
CALL V20210803181328__Insert_KRMUEmployeeIdCard() $$
DROP PROCEDURE IF EXISTS V20210803181328__Insert_KRMUEmployeeIdCard $$
DELIMITER ;